/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryDataRegionConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryDataRegionView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryDataStorageView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;

public class VolatilePageMemoryStorageEngine
implements StorageEngine {
    public static final String ENGINE_NAME = "aimem";
    private final VolatilePageMemoryStorageEngineConfiguration engineConfig;
    private final PageIoRegistry ioRegistry;
    private final Map<String, VolatilePageMemoryDataRegion> regions = new ConcurrentHashMap<String, VolatilePageMemoryDataRegion>();

    public VolatilePageMemoryStorageEngine(VolatilePageMemoryStorageEngineConfiguration engineConfig, PageIoRegistry ioRegistry) {
        this.engineConfig = engineConfig;
        this.ioRegistry = ioRegistry;
    }

    public void start() throws StorageException {
        this.addDataRegion(this.engineConfig.defaultRegion());
        this.engineConfig.regions().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<VolatilePageMemoryDataRegionView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<VolatilePageMemoryDataRegionView> ctx) {
                VolatilePageMemoryStorageEngine.this.addDataRegion((VolatilePageMemoryDataRegionConfiguration)ctx.config(VolatilePageMemoryDataRegionConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    public void stop() throws StorageException {
        try {
            IgniteUtils.closeAll(this.regions.values().stream().map(region -> region::stop));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    public VolatilePageMemoryTableStorage createMvTable(TableConfiguration tableCfg, TablesConfiguration tablesCfg) throws StorageException {
        VolatilePageMemoryDataStorageView dataStorageView = (VolatilePageMemoryDataStorageView)tableCfg.dataStorage().value();
        return new VolatilePageMemoryTableStorage(tableCfg, tablesCfg, this.regions.get(dataStorageView.dataRegion()));
    }

    private void addDataRegion(VolatilePageMemoryDataRegionConfiguration dataRegionConfig) {
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        String name = (String)dataRegionConfig.name().value();
        VolatilePageMemoryDataRegion dataRegion = new VolatilePageMemoryDataRegion(dataRegionConfig, this.ioRegistry, pageSize);
        dataRegion.start();
        this.regions.put(name, dataRegion);
    }
}

