/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteStreamerBenchmark
extends IgniteAbstractBenchmark {
    private List<String> cacheNames;
    private ExecutorService executor;
    private int entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.entries = this.args.range();
        if (this.entries <= 0) {
            throw new IllegalArgumentException("Invalid number of entries: " + this.entries);
        }
        if (cfg.threads() != 1) {
            throw new IllegalArgumentException("IgniteStreamerBenchmark should be run with single thread. Internally it starts multiple threads.");
        }
        String cacheNamePrefix = this.args.streamerCachesPrefix();
        if (cacheNamePrefix == null || cacheNamePrefix.isEmpty()) {
            throw new IllegalArgumentException("Streamer caches prefix not set.");
        }
        ArrayList<String> caches = new ArrayList<String>();
        for (String cacheName : this.ignite().cacheNames()) {
            if (!cacheName.startsWith(cacheNamePrefix)) continue;
            caches.add(cacheName);
        }
        if (caches.isEmpty()) {
            throw new IllegalArgumentException("Failed to find for IgniteStreamerBenchmark caches starting with '" + cacheNamePrefix + "'");
        }
        BenchmarkUtils.println((String)("Found " + caches.size() + " caches for IgniteStreamerBenchmark: " + caches));
        if (this.args.streamerCacheIndex() >= caches.size()) {
            throw new IllegalArgumentException("Invalid streamer cache index: " + this.args.streamerCacheIndex() + ", there are only " + caches.size() + " caches.");
        }
        if (this.args.streamerCacheIndex() + this.args.streamerConcurrentCaches() > caches.size()) {
            throw new IllegalArgumentException("There are no enough caches [cacheIndex=" + this.args.streamerCacheIndex() + ", concurrentCaches=" + this.args.streamerConcurrentCaches() + ", totalCaches=" + caches.size() + "]");
        }
        Collections.sort(caches);
        this.cacheNames = new ArrayList<String>(caches.subList(this.args.streamerCacheIndex(), this.args.streamerCacheIndex() + this.args.streamerConcurrentCaches()));
        this.executor = Executors.newFixedThreadPool(this.args.streamerConcurrentCaches());
        BenchmarkUtils.println((String)("IgniteStreamerBenchmark start [cacheIndex=" + this.args.streamerCacheIndex() + ", concurrentCaches=" + this.args.streamerConcurrentCaches() + ", entries=" + this.entries + ", bufferSize=" + this.args.streamerBufferSize() + ", cachesToUse=" + this.cacheNames + "]"));
        if (cfg.warmup() > 0L) {
            BenchmarkUtils.println((String)("IgniteStreamerBenchmark start warmup [warmupTimeMillis=" + cfg.warmup() + "]"));
            final long warmupEnd = System.currentTimeMillis() + cfg.warmup();
            final AtomicBoolean stop = new AtomicBoolean();
            try {
                ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
                for (final String string : this.cacheNames) {
                    futs.add(this.executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Thread.currentThread().setName("streamer-" + string);
                            BenchmarkUtils.println((String)("IgniteStreamerBenchmark start warmup for cache [name=" + string + "]"));
                            int KEYS = Math.min(100000, IgniteStreamerBenchmark.this.entries);
                            int key = 1;
                            try (IgniteDataStreamer streamer = IgniteStreamerBenchmark.this.ignite().dataStreamer(string);){
                                streamer.perNodeBufferSize(IgniteStreamerBenchmark.this.args.streamerBufferSize());
                                while (System.currentTimeMillis() < warmupEnd && !stop.get()) {
                                    for (int i = 0; i < 10; ++i) {
                                        streamer.addData((Object)(-key++), (Object)new SampleValue(key));
                                        if (key < KEYS) continue;
                                        key = 1;
                                    }
                                    streamer.flush();
                                }
                            }
                            BenchmarkUtils.println((String)("IgniteStreamerBenchmark finished warmup for cache [name=" + string + "]"));
                            return null;
                        }
                    }));
                }
                for (Future future : futs) {
                    future.get();
                }
            }
            finally {
                stop.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(Map<Object, Object> map) throws Exception {
        BenchmarkUtils.println((String)"IgniteStreamerBenchmark start test.");
        long start = System.currentTimeMillis();
        final AtomicBoolean stop = new AtomicBoolean();
        try {
            ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
            for (final String string : this.cacheNames) {
                futs.add(this.executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Thread.currentThread().setName("streamer-" + string);
                        long start = System.currentTimeMillis();
                        BenchmarkUtils.println((String)("IgniteStreamerBenchmark start load cache [name=" + string + "]"));
                        try (IgniteDataStreamer streamer = IgniteStreamerBenchmark.this.ignite().dataStreamer(string);){
                            for (int i = 0; i < IgniteStreamerBenchmark.this.entries; ++i) {
                                streamer.addData((Object)i, (Object)new SampleValue(i));
                                if (i <= 0 || i % 1000 != 0) continue;
                                if (stop.get()) {
                                    break;
                                }
                                if (i % 100000 != 0) continue;
                                BenchmarkUtils.println((String)("IgniteStreamerBenchmark cache load progress [name=" + string + ", entries=" + i + ", timeMillis=" + (System.currentTimeMillis() - start) + "]"));
                            }
                        }
                        long time = System.currentTimeMillis() - start;
                        BenchmarkUtils.println((String)("IgniteStreamerBenchmark finished load cache [name=" + string + ", entries=" + IgniteStreamerBenchmark.this.entries + ", bufferSize=" + IgniteStreamerBenchmark.this.args.streamerBufferSize() + ", totalTimeMillis=" + time + "]"));
                        return null;
                    }
                }));
            }
            for (Future future : futs) {
                future.get();
            }
        }
        finally {
            stop.set(true);
        }
        long time = System.currentTimeMillis() - start;
        BenchmarkUtils.println((String)("IgniteStreamerBenchmark finished [totalTimeMillis=" + time + ", entries=" + this.entries + ", bufferSize=" + this.args.streamerBufferSize() + "]"));
        for (String cacheName : this.cacheNames) {
            BenchmarkUtils.println((String)("Cache size [cacheName=" + cacheName + ", size=" + this.ignite().cache(cacheName).size(new CachePeekMode[0]) + "]"));
        }
        return false;
    }

    @Override
    public void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        super.tearDown();
    }
}

