/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class MetricUtils {
    public static final String SEPARATOR = ".";
    public static final String INF = "_inf";
    public static final char HISTOGRAM_NAME_DIVIDER = '_';
    private static final String CUSTOM_METRICS_PREF = "custom.";
    private static final Pattern CUSTOM_NAME_PATTERN = Pattern.compile("(?!\\.)(?!.*\\.$)(?!.*\\.\\.)(?!.*[\\s]+.*).+");

    public static String metricName(String ... names) {
        assert (names != null && names.length > 0) : "Metric name must consist of at least one element.";
        boolean custom = MetricUtils.customMetric(names[0]);
        for (int i = 0; i < names.length; ++i) {
            if (!F.isEmpty(names[i]) && (!custom || CUSTOM_NAME_PATTERN.matcher(names[i]).matches())) continue;
            throw new IllegalArgumentException("Illegal metric or registry name: '" + names[i] + "'. Spaces, nulls, empty name or name parts are not allowed.");
        }
        return String.join((CharSequence)SEPARATOR, names);
    }

    public static boolean customMetric(String name) {
        return name != null && (name.startsWith(CUSTOM_METRICS_PREF) || name.equals("custom"));
    }

    public static String customName(String name) {
        return MetricUtils.metricName("custom", name);
    }

    public static T2<String, String> fromFullName(String name) {
        String metricName;
        String regName;
        int metricNamePos = name.lastIndexOf(SEPARATOR);
        if (metricNamePos == -1) {
            regName = name;
            metricName = "";
        } else {
            regName = name.substring(0, metricNamePos);
            metricName = name.substring(metricNamePos + 1);
        }
        return new T2<String, String>(regName, metricName);
    }

    public static String cacheMetricsRegistryName(String cacheName, boolean isNear) {
        if (isNear) {
            return MetricUtils.metricName("cache", cacheName, "near");
        }
        return MetricUtils.metricName("cache", cacheName);
    }

    public static String cacheGroupMetricsRegistryName(String cacheOrGroupName) {
        return MetricUtils.metricName("cacheGroups", cacheOrGroupName);
    }

    public static boolean compareAndSet(AtomicLongMetric m, long expect, long update) {
        return AtomicLongMetric.updater.compareAndSet(m, expect, update);
    }

    public static void setIfLess(AtomicLongMetric m, long update) {
        long v = m.value();
        while (v > update && !AtomicLongMetric.updater.compareAndSet(m, v, update)) {
            v = m.value();
        }
    }

    public static void setIfGreater(AtomicLongMetric m, long update) {
        long v = m.value();
        while (v < update && !AtomicLongMetric.updater.compareAndSet(m, v, update)) {
            v = m.value();
        }
    }

    public static String[] histogramBucketNames(HistogramMetric metric) {
        String name = metric.name();
        long[] bounds = metric.bounds();
        String[] names = new String[bounds.length + 1];
        long min = 0L;
        for (int i = 0; i < bounds.length; ++i) {
            names[i] = name + "_" + min + "_" + bounds[i];
            min = bounds[i];
        }
        names[bounds.length] = name + "_" + min + INF;
        return names;
    }

    public static String toSqlName(String name) {
        return name.replaceAll("([A-Z])", "_$1").replaceAll("\\.", "_").toUpperCase();
    }

    public static Map<String, Class<?>> systemViewAttributes(SystemView<?> sysView) {
        final LinkedHashMap attrs = new LinkedHashMap(sysView.walker().count());
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            @Override
            public <T> void accept(int idx, String name, Class<T> clazz) {
                attrs.put(name, clazz);
            }
        });
        return attrs;
    }
}

