/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.Partition;
import org.apache.helix.tools.ClusterVerifier;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ClusterExternalViewVerifier
extends ClusterVerifier {
    private static Logger LOG = LoggerFactory.getLogger(ClusterExternalViewVerifier.class);
    final List<String> _expectSortedLiveNodes;

    public ClusterExternalViewVerifier(HelixZkClient zkclient, String clusterName, List<String> expectLiveNodes) {
        super(zkclient, clusterName);
        this._expectSortedLiveNodes = expectLiveNodes;
        Collections.sort(this._expectSortedLiveNodes);
    }

    boolean verifyLiveNodes(List<String> actualLiveNodes) {
        Collections.sort(actualLiveNodes);
        return this._expectSortedLiveNodes.equals(actualLiveNodes);
    }

    boolean verifyExternalView(ExternalView externalView, Map<Partition, Map<String, String>> bestPossibleState) {
        Map<String, Map<String, String>> bestPossibleStateMap = ClusterExternalViewVerifier.convertBestPossibleState(bestPossibleState);
        Map<String, Map<String, String>> externalViewMap = externalView.getRecord().getMapFields();
        return externalViewMap.equals(bestPossibleStateMap);
    }

    static void runStage(ClusterEvent event, Stage stage) throws Exception {
        StageContext context = new StageContext();
        stage.init(context);
        stage.preProcess();
        stage.process(event);
        stage.postProcess();
    }

    BestPossibleStateOutput calculateBestPossibleState(ResourceControllerDataProvider cache) throws Exception {
        ClusterEvent event = new ClusterEvent(ClusterEventType.StateVerifier);
        event.addAttribute(AttributeName.ControllerDataProvider.name(), cache);
        ArrayList<AbstractBaseStage> stages = new ArrayList<AbstractBaseStage>();
        stages.add(new ResourceComputationStage());
        stages.add(new CurrentStateComputationStage());
        stages.add(new BestPossibleStateCalcStage());
        for (Stage stage : stages) {
            ClusterExternalViewVerifier.runStage(event, stage);
        }
        return (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
    }

    static Map<String, Map<String, String>> convertBestPossibleState(Map<Partition, Map<String, String>> bestPossibleState) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Partition partition : bestPossibleState.keySet()) {
            result.put(partition.getPartitionName(), bestPossibleState.get(partition));
        }
        return result;
    }

    @Override
    public boolean verify() throws Exception {
        ResourceControllerDataProvider cache = new ResourceControllerDataProvider();
        cache.refresh(this._accessor);
        ArrayList<String> liveInstances = new ArrayList<String>();
        liveInstances.addAll(cache.getAssignableLiveInstances().keySet());
        boolean success = this.verifyLiveNodes(liveInstances);
        if (!success) {
            LOG.info("liveNodes not match, expect: " + this._expectSortedLiveNodes + ", actual: " + liveInstances);
            return false;
        }
        BestPossibleStateOutput bestPossbileStates = this.calculateBestPossibleState(cache);
        Map externalViews = this._accessor.getChildValuesMap(this._keyBuilder.externalViews(), true);
        for (String resourceName : externalViews.keySet()) {
            Map<Partition, Map<String, String>> bestPossbileState;
            ExternalView externalView = (ExternalView)externalViews.get(resourceName);
            success = this.verifyExternalView(externalView, bestPossbileState = bestPossbileStates.getResourceMap(resourceName));
            if (success) continue;
            LOG.info("external-view for resource: " + resourceName + " not match");
            return false;
        }
        return true;
    }
}

