/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.api.rebalancer.constraint.AbnormalStateResolver;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcessiveTopStateResolver
implements AbnormalStateResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ExcessiveTopStateResolver.class);

    @Override
    public boolean checkCurrentStates(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef) {
        if (!stateModelDef.isSingleTopStateModel()) {
            return true;
        }
        return currentStateOutput.getCurrentStateMap(resourceName, partition).values().stream().filter(state -> state.equals(stateModelDef.getTopState())).count() <= 1L;
    }

    @Override
    public Map<String, String> computeRecoveryAssignment(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, StateModelDefinition stateModelDef, List<String> preferenceList) {
        String expectedTopStateHost;
        Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
        if (this.checkCurrentStates(currentStateOutput, resourceName, partition, stateModelDef)) {
            LOG.warn("The input current state map {} is valid, return the original current state.", currentStateMap);
            return currentStateMap;
        }
        HashMap<String, String> recoverMap = new HashMap<String, String>(currentStateMap);
        String recoveryState = stateModelDef.getNextStateForTransition(stateModelDef.getTopState(), stateModelDef.getInitialState());
        if (preferenceList != null && !preferenceList.isEmpty() && ((String)recoverMap.get(expectedTopStateHost = preferenceList.get(0))).equals(stateModelDef.getTopState())) {
            recoverMap.put(expectedTopStateHost, recoveryState);
        }
        boolean hasReservedTopState = false;
        for (String instance : recoverMap.keySet()) {
            if (!((String)recoverMap.get(instance)).equals(stateModelDef.getTopState())) continue;
            if (hasReservedTopState) {
                recoverMap.put(instance, recoveryState);
                continue;
            }
            hasReservedTopState = true;
        }
        return recoverMap;
    }
}

