/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.util;

import groovyx.gpars.util.MessageQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class FQMessageQueue
implements MessageQueue {
    private volatile Node outside = new EmptyNode();
    private Node inside = new EmptyNode();
    private final AtomicReferenceFieldUpdater outsideUpdater = AtomicReferenceFieldUpdater.newUpdater(FQMessageQueue.class, Node.class, "outside");

    @Override
    public boolean isEmpty() {
        return this.inside.isEmpty() && this.outside.isEmpty();
    }

    @Override
    public Object poll() {
        EmptyNode newOutside;
        Node copy;
        if (!this.inside.isEmpty()) {
            return this.pollFromInside();
        }
        while (!this.outsideUpdater.compareAndSet(this, copy = this.outside, newOutside = new EmptyNode())) {
        }
        while (!copy.isEmpty()) {
            Node current = copy;
            copy = copy.next;
            current.next = this.inside;
            this.inside = current;
        }
        if (!this.inside.isEmpty()) {
            return this.pollFromInside();
        }
        return null;
    }

    private Object pollFromInside() {
        Object result = this.inside.value;
        this.inside = this.inside.next;
        return result;
    }

    @Override
    public void add(Object element) {
        Node newNode;
        Node currentNode;
        while (!this.outsideUpdater.compareAndSet(this, currentNode = this.outside, newNode = new Node(currentNode, element))) {
        }
    }

    static final class EmptyNode
    extends Node {
        EmptyNode() {
            super(null, null);
        }

        @Override
        boolean isEmpty() {
            return true;
        }
    }

    static class Node {
        Node next;
        final Object value;

        Node(Node next, Object value) {
            this.next = next;
            this.value = value;
        }

        boolean isEmpty() {
            return false;
        }
    }
}

