/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.Date;
import java.util.Locale;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyAntSettings;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;

public abstract class IvyTask
extends Task {
    public static final String ANT_PROJECT_CONTEXT_KEY = "ant-project";
    private Boolean validate = null;
    private Reference antIvyEngineRef = null;

    protected boolean doValidate(IvySettings ivy) {
        if (this.validate == null) {
            return ivy.doValidate();
        }
        return this.validate;
    }

    public boolean isValidate() {
        return this.validate == null || this.validate != false;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setSettingsRef(Reference ref) {
        this.antIvyEngineRef = ref;
    }

    public Reference getSettingsRef() {
        return this.antIvyEngineRef;
    }

    protected IvySettings getSettings() {
        return this.getIvyInstance().getSettings();
    }

    protected Ivy getIvyInstance() {
        Object antIvyEngine;
        if (this.antIvyEngineRef == null) {
            antIvyEngine = IvyAntSettings.getDefaultInstance(this);
        } else {
            antIvyEngine = this.antIvyEngineRef.getReferencedObject(this.getProject());
            if (!antIvyEngine.getClass().getName().equals(IvyAntSettings.class.getName())) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " doesn't reference an ivy:settings", this.getLocation());
            }
            if (!(antIvyEngine instanceof IvyAntSettings)) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " has been defined in a different classloader.  Please use the same loader when defining your task, or redeclare your ivy:settings in this classloader", this.getLocation());
            }
        }
        Ivy ivy = ((IvyAntSettings)((Object)antIvyEngine)).getConfiguredIvyInstance(this);
        AntMessageLogger.register((ProjectComponent)this, ivy);
        return ivy;
    }

    protected void setResolved(ResolveReport report, boolean keep) {
        ModuleDescriptor md = report.getModuleDescriptor();
        String[] confs = report.getConfigurations();
        if (keep) {
            this.getProject().addReference("ivy.resolved.report", (Object)report);
            this.getProject().addReference("ivy.resolved.configurations.ref", (Object)confs);
            this.getProject().addReference("ivy.resolved.descriptor", (Object)md);
        }
        String suffix = md.getModuleRevisionId().getModuleId().getOrganisation() + "." + md.getModuleRevisionId().getModuleId().getName();
        this.getProject().addReference("ivy.resolved.report." + suffix, (Object)report);
        this.getProject().addReference("ivy.resolved.descriptor." + suffix, (Object)md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + suffix, (Object)confs);
    }

    protected void setResolved(ResolveReport report, String resolveId, boolean keep) {
        this.setResolved(report, keep);
        if (resolveId == null) {
            return;
        }
        ModuleDescriptor md = report.getModuleDescriptor();
        String[] confs = report.getConfigurations();
        this.getProject().addReference("ivy.resolved.report." + resolveId, (Object)report);
        this.getProject().addReference("ivy.resolved.descriptor." + resolveId, (Object)md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + resolveId, (Object)confs);
    }

    protected String[] getResolvedConfigurations(String org, String module, boolean strict) {
        return (String[])this.getReference("ivy.resolved.configurations.ref", org, module, strict);
    }

    protected <T> T getResolvedDescriptor(String resolveId) {
        return this.getResolvedDescriptor(resolveId, true);
    }

    protected <T> T getResolvedDescriptor(String resolveId, boolean strict) {
        Object result = this.getProject().getReference("ivy.resolved.descriptor." + resolveId);
        if (strict && result == null) {
            throw new BuildException("ModuleDescriptor for resolve with id '" + resolveId + "' not found.");
        }
        return (T)result;
    }

    protected <T> T getResolvedDescriptor(String org, String module) {
        return this.getResolvedDescriptor(org, module, false);
    }

    protected <T> T getResolvedDescriptor(String org, String module, boolean strict) {
        return this.getReference("ivy.resolved.descriptor", org, module, strict);
    }

    private <T> T getReference(String prefix, String org, String module, boolean strict) {
        Object reference = null;
        if (org != null && module != null) {
            reference = this.getProject().getReference(prefix + "." + org + "." + module);
        }
        if (!strict && reference == null) {
            reference = this.getProject().getReference(prefix);
        }
        return (T)reference;
    }

    protected ResolveReport getResolvedReport(String org, String module, String resolveId) {
        if (resolveId == null) {
            return (ResolveReport)this.getReference("ivy.resolved.report", org, module, false);
        }
        return (ResolveReport)this.getReference("ivy.resolved.report." + resolveId, null, null, false);
    }

    protected String[] splitConfs(String conf) {
        return StringUtils.splitToArray(conf);
    }

    protected String mergeConfs(String[] conf) {
        return StringUtils.joinArray(conf, ", ");
    }

    protected static Date getPubDate(String date, Date def) {
        if (date == null) {
            return def;
        }
        if ("now".equals(date.toLowerCase(Locale.US))) {
            return new Date();
        }
        try {
            return DateUtil.parse(date);
        }
        catch (Exception ex) {
            throw new BuildException("Publication date provided in bad format. Should be 'yyyyMMddHHmmss' and not '" + date + "'!");
        }
    }

    protected String getProperty(String value, IvySettings ivy, String name) {
        if (value == null) {
            return this.getProperty(ivy, name);
        }
        value = ivy.substitute(value);
        Message.debug("parameter found as attribute value: " + name + "=" + value);
        return value;
    }

    protected String getProperty(String value, IvySettings ivy, String name, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(value, ivy, name);
        }
        return this.getProperty(value, ivy, name + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(ivy, name);
        }
        return this.getProperty(ivy, name + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name) {
        String val = ivy.getVariable(name);
        if (val == null) {
            val = ivy.substitute(this.getProject().getProperty(name));
            if (val == null) {
                Message.debug("parameter not found: " + name);
            } else {
                Message.debug("parameter found as ant project property: " + name + "=" + val);
            }
        } else {
            val = ivy.substitute(val);
            Message.debug("parameter found as ivy variable: " + name + "=" + val);
        }
        return val;
    }

    protected void prepareTask() {
        this.getProject().setProperty("ivy.version", Ivy.getIvyVersion());
        IvyContext.pushNewCopyContext();
        IvyContext.getContext().setIvy(this.getIvyInstance());
        IvyContext.getContext().push(ANT_PROJECT_CONTEXT_KEY, this.getProject());
    }

    protected void finalizeTask() {
        if (!IvyContext.getContext().pop(ANT_PROJECT_CONTEXT_KEY, this.getProject())) {
            Message.error("ANT project popped from stack not equals current! Ignoring");
        }
        IvyContext.popContext();
    }

    public final void execute() throws BuildException {
        try {
            this.prepareTask();
            this.doExecute();
        }
        finally {
            this.finalizeTask();
        }
    }

    public abstract void doExecute() throws BuildException;

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.getTaskName();
    }

    protected void cacheAttributeNotSupported() {
        throw new BuildException("cache attribute is not supported any more. See IVY-685 for details.");
    }
}

