/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var toc = {
"title": "Apache FreeMarker Manual",
"url": "toc.html",
"isFile": true,
"children": [
{
"title": "What is Apache FreeMarker?",
"url": "index.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Template Author's Guide",
"url": "dgui.html",
"isFile": true,
"children": [
{
"title": "Getting Started",
"url": "dgui_quickstart.html",
"isFile": true,
"children": [
{
"title": "Template + data-model = output",
"url": "dgui_quickstart_basics.html",
"isFile": true,
"children": [
]
}
,
{
"title": "The data-model at a glance",
"url": "dgui_quickstart_datamodel.html",
"isFile": true,
"children": [
]
}
,
{
"title": "The template at a glance",
"url": "dgui_quickstart_template.html",
"isFile": true,
"children": [
{
"title": "Some basic directives",
"url": "dgui_quickstart_template.html#autoid_2",
"isFile": false,
"children": [
{
"title": "The if directive",
"url": "dgui_quickstart_template.html#autoid_3",
"isFile": false,
"children": [
]
}
,
{
"title": "The list directive",
"url": "dgui_quickstart_template.html#autoid_4",
"isFile": false,
"children": [
]
}
,
{
"title": "The include directive",
"url": "dgui_quickstart_template.html#autoid_5",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Using directives together",
"url": "dgui_quickstart_template.html#autoid_6",
"isFile": false,
"children": [
]
}
,
{
"title": "Using built-ins",
"url": "dgui_quickstart_template.html#autoid_7",
"isFile": false,
"children": [
]
}
,
{
"title": "Dealing with missing variables",
"url": "dgui_quickstart_template.html#autoid_8",
"isFile": false,
"children": [
]
}
,
{
"title": "Escaping for HTML, XML and other markup",
"url": "dgui_quickstart_template.html#dgui_quickstart_template_autoescaping",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Values, Types",
"url": "dgui_datamodel.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "dgui_datamodel_basics.html",
"isFile": true,
"children": [
{
"title": "What is a value?",
"url": "dgui_datamodel_basics.html#topic.value",
"isFile": false,
"children": [
]
}
,
{
"title": "What is type?",
"url": "dgui_datamodel_basics.html#autoid_9",
"isFile": false,
"children": [
]
}
,
{
"title": "The data-model is a hash",
"url": "dgui_datamodel_basics.html#autoid_10",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "The types",
"url": "dgui_datamodel_types.html",
"isFile": true,
"children": [
{
"title": "Scalars",
"url": "dgui_datamodel_types.html#dgui_datamodel_scalar",
"isFile": false,
"children": [
]
}
,
{
"title": "Containers",
"url": "dgui_datamodel_types.html#dgui_datamodel_container",
"isFile": false,
"children": [
]
}
,
{
"title": "Subroutines",
"url": "dgui_datamodel_types.html#autoid_11",
"isFile": false,
"children": [
{
"title": "Methods and functions",
"url": "dgui_datamodel_types.html#dgui_datamodel_method",
"isFile": false,
"children": [
]
}
,
{
"title": "User-defined directives",
"url": "dgui_datamodel_types.html#dgui_datamodel_userdefdir",
"isFile": false,
"children": [
]
}
,
{
"title": "Function/method versus user-defined directive",
"url": "dgui_datamodel_types.html#autoid_12",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Miscellaneous",
"url": "dgui_datamodel_types.html#autoid_13",
"isFile": false,
"children": [
{
"title": "Nodes",
"url": "dgui_datamodel_types.html#dgui_datamodel_node",
"isFile": false,
"children": [
]
}
,
{
"title": "Markup output",
"url": "dgui_datamodel_types.html#dgui_datamodel_markupoutput",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "The Template",
"url": "dgui_template.html",
"isFile": true,
"children": [
{
"title": "Overall structure",
"url": "dgui_template_overallstructure.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Directives",
"url": "dgui_template_directives.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Expressions",
"url": "dgui_template_exp.html",
"isFile": true,
"children": [
{
"title": "Quick overview (cheat sheet)",
"url": "dgui_template_exp.html#exp_cheatsheet",
"isFile": false,
"children": [
]
}
,
{
"title": "Specify values directly",
"url": "dgui_template_exp.html#dgui_template_exp_direct",
"isFile": false,
"children": [
{
"title": "Strings",
"url": "dgui_template_exp.html#dgui_template_exp_direct_string",
"isFile": false,
"children": [
]
}
,
{
"title": "Numbers",
"url": "dgui_template_exp.html#dgui_template_exp_direct_number",
"isFile": false,
"children": [
]
}
,
{
"title": "Booleans",
"url": "dgui_template_exp.html#dgui_template_exp_direct_boolean",
"isFile": false,
"children": [
]
}
,
{
"title": "Sequences",
"url": "dgui_template_exp.html#dgui_template_exp_direct_seuqence",
"isFile": false,
"children": [
]
}
,
{
"title": "Ranges",
"url": "dgui_template_exp.html#dgui_template_exp_direct_ranges",
"isFile": false,
"children": [
]
}
,
{
"title": "Hashes",
"url": "dgui_template_exp.html#dgui_template_exp_direct_hash",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Retrieving variables",
"url": "dgui_template_exp.html#dgui_template_exp_var",
"isFile": false,
"children": [
{
"title": "Top-level variables",
"url": "dgui_template_exp.html#dgui_template_exp_var_toplevel",
"isFile": false,
"children": [
]
}
,
{
"title": "Retrieving data from a hash",
"url": "dgui_template_exp.html#dgui_template_exp_var_hash",
"isFile": false,
"children": [
]
}
,
{
"title": "Retrieving data from a sequence",
"url": "dgui_template_exp.html#dgui_template_exp_var_sequence",
"isFile": false,
"children": [
]
}
,
{
"title": "Special variables",
"url": "dgui_template_exp.html#dgui_template_exp_var_special",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "String operations",
"url": "dgui_template_exp.html#dgui_template_exp_stringop",
"isFile": false,
"children": [
{
"title": "Interpolation and concatenation",
"url": "dgui_template_exp.html#dgui_template_exp_stringop_interpolation",
"isFile": false,
"children": [
]
}
,
{
"title": "Getting a character",
"url": "dgui_template_exp.html#dgui_template_exp_get_character",
"isFile": false,
"children": [
]
}
,
{
"title": "String slicing (substrings)",
"url": "dgui_template_exp.html#dgui_template_exp_stringop_slice",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Sequence operations",
"url": "dgui_template_exp.html#dgui_template_exp_sequenceop",
"isFile": false,
"children": [
{
"title": "Concatenation",
"url": "dgui_template_exp.html#dgui_template_exp_sequenceop_cat",
"isFile": false,
"children": [
]
}
,
{
"title": "Sequence slicing",
"url": "dgui_template_exp.html#dgui_template_exp_seqenceop_slice",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Hash operations",
"url": "dgui_template_exp.html#dgui_template_exp_hashop",
"isFile": false,
"children": [
{
"title": "Concatenation",
"url": "dgui_template_exp.html#dgui_template_exp_hashop_cat",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Arithmetical calculations",
"url": "dgui_template_exp.html#dgui_template_exp_arit",
"isFile": false,
"children": [
]
}
,
{
"title": "Comparison",
"url": "dgui_template_exp.html#dgui_template_exp_comparison",
"isFile": false,
"children": [
]
}
,
{
"title": "Logical operations",
"url": "dgui_template_exp.html#dgui_template_exp_logicalop",
"isFile": false,
"children": [
]
}
,
{
"title": "Built-ins",
"url": "dgui_template_exp.html#dgui_template_exp_builtin",
"isFile": false,
"children": [
]
}
,
{
"title": "Method call",
"url": "dgui_template_exp.html#dgui_template_exp_methodcall",
"isFile": false,
"children": [
]
}
,
{
"title": "Handling missing values",
"url": "dgui_template_exp.html#dgui_template_exp_missing",
"isFile": false,
"children": [
{
"title": "Default value operator",
"url": "dgui_template_exp.html#dgui_template_exp_missing_default",
"isFile": false,
"children": [
]
}
,
{
"title": "Missing value test operator",
"url": "dgui_template_exp.html#dgui_template_exp_missing_test",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Assignment Operators",
"url": "dgui_template_exp.html#dgui_template_exp_assignment",
"isFile": false,
"children": [
]
}
,
{
"title": "Local lambdas",
"url": "dgui_template_exp.html#dgui_template_exp_lambda",
"isFile": false,
"children": [
]
}
,
{
"title": "Parentheses",
"url": "dgui_template_exp.html#dgui_template_exp_parentheses",
"isFile": false,
"children": [
]
}
,
{
"title": "White-space in expressions",
"url": "dgui_template_exp.html#dgui_template_exp_whitespace",
"isFile": false,
"children": [
]
}
,
{
"title": "Comments in expressions",
"url": "dgui_template_exp.html#dgui_template_exp_comment",
"isFile": false,
"children": [
]
}
,
{
"title": "Operator precedence",
"url": "dgui_template_exp.html#dgui_template_exp_precedence",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Interpolations",
"url": "dgui_template_valueinsertion.html",
"isFile": true,
"children": [
{
"title": "Overview",
"url": "dgui_template_valueinsertion.html#autoid_14",
"isFile": false,
"children": [
]
}
,
{
"title": "Automatic escaping",
"url": "dgui_template_valueinsertion.html#autoid_15",
"isFile": false,
"children": [
]
}
,
{
"title": "Guide to inserting numerical values",
"url": "dgui_template_valueinsertion.html#autoid_16",
"isFile": false,
"children": [
]
}
,
{
"title": "Guide to inserting date/time/date-time values",
"url": "dgui_template_valueinsertion.html#dgui_template_valueinserion_universal_date",
"isFile": false,
"children": [
]
}
,
{
"title": "Guide to inserting boolean values",
"url": "dgui_template_valueinsertion.html#autoid_17",
"isFile": false,
"children": [
]
}
,
{
"title": "Exact conversion rules",
"url": "dgui_template_valueinsertion.html#autoid_18",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Miscellaneous",
"url": "dgui_misc.html",
"isFile": true,
"children": [
{
"title": "Defining your own directives",
"url": "dgui_misc_userdefdir.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "dgui_misc_userdefdir.html#autoid_19",
"isFile": false,
"children": [
]
}
,
{
"title": "Parameters",
"url": "dgui_misc_userdefdir.html#autoid_20",
"isFile": false,
"children": [
]
}
,
{
"title": "Nested content",
"url": "dgui_misc_userdefdir.html#autoid_21",
"isFile": false,
"children": [
]
}
,
{
"title": "Macros with loop variables",
"url": "dgui_misc_userdefdir.html#dgui_misc_userdefdir_loopvar",
"isFile": false,
"children": [
]
}
,
{
"title": "More about user-defined directives and macros",
"url": "dgui_misc_userdefdir.html#autoid_22",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Defining variables in the template",
"url": "dgui_misc_var.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Namespaces",
"url": "dgui_misc_namespace.html",
"isFile": true,
"children": [
{
"title": "Creating a library",
"url": "dgui_misc_namespace.html#autoid_23",
"isFile": false,
"children": [
]
}
,
{
"title": "Writing the variables of imported namespaces",
"url": "dgui_misc_namespace.html#autoid_24",
"isFile": false,
"children": [
]
}
,
{
"title": "Namespaces and data-model",
"url": "dgui_misc_namespace.html#autoid_25",
"isFile": false,
"children": [
]
}
,
{
"title": "The life-cycle of namespaces",
"url": "dgui_misc_namespace.html#autoid_26",
"isFile": false,
"children": [
]
}
,
{
"title": "Auto-importing",
"url": "dgui_misc_namespace.html#autoid_27",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Auto-escaping and output formats",
"url": "dgui_misc_autoescaping.html",
"isFile": true,
"children": [
{
"title": "Output formats",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_outputformat",
"isFile": false,
"children": [
]
}
,
{
"title": "Overriding the output format in templates",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_overrideoformat",
"isFile": false,
"children": [
]
}
,
{
"title": "Disabling auto escaping",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_disableautoesc",
"isFile": false,
"children": [
]
}
,
{
"title": "“Markup output” values",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_movalues",
"isFile": false,
"children": [
]
}
,
{
"title": "Further details and tricky cases",
"url": "dgui_misc_autoescaping.html#autoid_28",
"isFile": false,
"children": [
{
"title": "Non-markup output formats",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_nonmarkupof",
"isFile": false,
"children": [
]
}
,
{
"title": "Inserting markup output values from other markups",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_mixingoutputformats",
"isFile": false,
"children": [
]
}
,
{
"title": "“+”\n operator",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_concatenation",
"isFile": false,
"children": [
]
}
,
{
"title": "${...} inside string literals",
"url": "dgui_misc_autoescaping.html#dgui_misc_autoescaping_stringliteral",
"isFile": false,
"children": [
]
}
,
{
"title": "Combined output formats",
"url": "dgui_misc_autoescaping.html#autoid_29",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Formatting for humans, or for computers",
"url": "dgui_misc_computer_vs_human_format.html",
"isFile": true,
"children": [
]
}
,
{
"title": "White-space handling",
"url": "dgui_misc_whitespace.html",
"isFile": true,
"children": [
{
"title": "White-space stripping",
"url": "dgui_misc_whitespace.html#dgui_misc_whitespace_stripping",
"isFile": false,
"children": [
]
}
,
{
"title": "Using compress directive",
"url": "dgui_misc_whitespace.html#autoid_30",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Alternative (square bracket) syntax",
"url": "dgui_misc_alternativesyntax.html",
"isFile": true,
"children": [
{
"title": "Square bracket tag syntax",
"url": "dgui_misc_alternativesyntax.html#dgui_misc_alternativesyntax_tag",
"isFile": false,
"children": [
]
}
,
{
"title": "Square bracket interpolation syntax",
"url": "dgui_misc_alternativesyntax.html#dgui_misc_alternativesyntax_interpolation",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "Programmer's Guide",
"url": "pgui.html",
"isFile": true,
"children": [
{
"title": "Getting Started",
"url": "pgui_quickstart.html",
"isFile": true,
"children": [
{
"title": "Create a configuration instance",
"url": "pgui_quickstart_createconfiguration.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Create a data-model",
"url": "pgui_quickstart_createdatamodel.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Get the template",
"url": "pgui_quickstart_gettemplate.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Merging the template with the data-model",
"url": "pgui_quickstart_merge.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Putting all together",
"url": "pgui_quickstart_all.html",
"isFile": true,
"children": [
]
}
]
}
,
{
"title": "The Data Model",
"url": "pgui_datamodel.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "pgui_datamodel_basics.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Scalars",
"url": "pgui_datamodel_scalar.html",
"isFile": true,
"children": [
{
"title": "“date-like” types",
"url": "pgui_datamodel_scalar.html#autoid_31",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Containers",
"url": "pgui_datamodel_parent.html",
"isFile": true,
"children": [
{
"title": "Hashes",
"url": "pgui_datamodel_parent.html#autoid_32",
"isFile": false,
"children": [
]
}
,
{
"title": "Sequences",
"url": "pgui_datamodel_parent.html#autoid_33",
"isFile": false,
"children": [
]
}
,
{
"title": "Collections",
"url": "pgui_datamodel_parent.html#autoid_34",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Methods",
"url": "pgui_datamodel_method.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Directives",
"url": "pgui_datamodel_directive.html",
"isFile": true,
"children": [
{
"title": "Example 1",
"url": "pgui_datamodel_directive.html#autoid_35",
"isFile": false,
"children": [
]
}
,
{
"title": "Example 2",
"url": "pgui_datamodel_directive.html#autoid_36",
"isFile": false,
"children": [
]
}
,
{
"title": "Notices",
"url": "pgui_datamodel_directive.html#autoid_37",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Node variables",
"url": "pgui_datamodel_node.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Object wrappers",
"url": "pgui_datamodel_objectWrapper.html",
"isFile": true,
"children": [
{
"title": "The default object wrapper",
"url": "pgui_datamodel_objectWrapper.html#pgui_datamodel_defaultObjectWrapper",
"isFile": false,
"children": [
]
}
,
{
"title": "Custom object wrapping example",
"url": "pgui_datamodel_objectWrapper.html#pgui_datamodel_customObjectWrappingExample",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "The Configuration",
"url": "pgui_config.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "pgui_config_basics.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Shared variables",
"url": "pgui_config_sharedvariables.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Settings",
"url": "pgui_config_settings.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Template loading",
"url": "pgui_config_templateloading.html",
"isFile": true,
"children": [
{
"title": "Template loaders",
"url": "pgui_config_templateloading.html#autoid_38",
"isFile": false,
"children": [
{
"title": "Built-in template loaders",
"url": "pgui_config_templateloading.html#autoid_39",
"isFile": false,
"children": [
]
}
,
{
"title": "Loading templates from multiple locations",
"url": "pgui_config_templateloading.html#autoid_40",
"isFile": false,
"children": [
]
}
,
{
"title": "Loading templates from other sources",
"url": "pgui_config_templateloading.html#autoid_41",
"isFile": false,
"children": [
]
}
,
{
"title": "The template name (template path)",
"url": "pgui_config_templateloading.html#autoid_42",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Template caching",
"url": "pgui_config_templateloading.html#pgui_config_templateloading_caching",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Error handling",
"url": "pgui_config_errorhandling.html",
"isFile": true,
"children": [
{
"title": "The possible exceptions",
"url": "pgui_config_errorhandling.html#autoid_43",
"isFile": false,
"children": [
]
}
,
{
"title": "Customizing the behavior regarding\n TemplateException-s",
"url": "pgui_config_errorhandling.html#autoid_44",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateException logging",
"url": "pgui_config_errorhandling.html#autoid_45",
"isFile": false,
"children": [
]
}
,
{
"title": "Explicit error handling in templates",
"url": "pgui_config_errorhandling.html#autoid_46",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Template configurations",
"url": "pgui_config_templateconfigurations.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Associating output formats with templates",
"url": "pgui_config_outputformatsautoesc.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Custom number and date/time formats",
"url": "pgui_config_custom_formats.html",
"isFile": true,
"children": [
{
"title": "Overview",
"url": "pgui_config_custom_formats.html#autoid_50",
"isFile": false,
"children": [
]
}
,
{
"title": "Simple custom number format example",
"url": "pgui_config_custom_formats.html#pgui_config_custom_formats_ex_cust_alg_simple",
"isFile": false,
"children": [
]
}
,
{
"title": "Advanced custom number format example",
"url": "pgui_config_custom_formats.html#pgui_config_custom_formats_ex_cust_algo_advanced",
"isFile": false,
"children": [
]
}
,
{
"title": "Custom date/time format example",
"url": "pgui_config_custom_formats.html#pgui_config_custom_formats_ex_cust_algo_date",
"isFile": false,
"children": [
]
}
,
{
"title": "Alias format example",
"url": "pgui_config_custom_formats.html#pgui_config_custom_formats_ex_alias",
"isFile": false,
"children": [
]
}
,
{
"title": "Model-aware format example",
"url": "pgui_config_custom_formats.html#pgui_config_custom_formats_ex_model_aware",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "The \"incompatible improvements\" setting",
"url": "pgui_config_incompatible_improvements.html",
"isFile": true,
"children": [
{
"title": "What does it do",
"url": "pgui_config_incompatible_improvements.html#autoid_51",
"isFile": false,
"children": [
]
}
,
{
"title": "How to set it",
"url": "pgui_config_incompatible_improvements.html#pgui_config_incompatible_improvements_how_to_set",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Miscellaneous",
"url": "pgui_misc.html",
"isFile": true,
"children": [
{
"title": "Variables, scopes",
"url": "pgui_misc_var.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Charset issues",
"url": "pgui_misc_charset.html",
"isFile": true,
"children": [
{
"title": "The charset of the input",
"url": "pgui_misc_charset.html#autoid_52",
"isFile": false,
"children": [
]
}
,
{
"title": "The charset of the output",
"url": "pgui_misc_charset.html#autoid_53",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Multithreading",
"url": "pgui_misc_multithreading.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Bean wrapper",
"url": "pgui_misc_beanwrapper.html",
"isFile": true,
"children": [
{
"title": "TemplateHashModel functionality",
"url": "pgui_misc_beanwrapper.html#beanswrapper_hash",
"isFile": false,
"children": [
]
}
,
{
"title": "A word on security",
"url": "pgui_misc_beanwrapper.html#autoid_54",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateScalarModel functionality",
"url": "pgui_misc_beanwrapper.html#autoid_55",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateNumberModel functionality",
"url": "pgui_misc_beanwrapper.html#autoid_56",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateCollectionModel functionality",
"url": "pgui_misc_beanwrapper.html#autoid_57",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateSequenceModel functionality",
"url": "pgui_misc_beanwrapper.html#autoid_58",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateMethodModel functionality",
"url": "pgui_misc_beanwrapper.html#beanswrapper_method",
"isFile": false,
"children": [
]
}
,
{
"title": "Unwrapping rules",
"url": "pgui_misc_beanwrapper.html#autoid_59",
"isFile": false,
"children": [
]
}
,
{
"title": "Accessing static methods",
"url": "pgui_misc_beanwrapper.html#autoid_60",
"isFile": false,
"children": [
]
}
,
{
"title": "Accessing enums",
"url": "pgui_misc_beanwrapper.html#jdk_15_enums",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Logging",
"url": "pgui_misc_logging.html",
"isFile": true,
"children": [
{
"title": "Logging library selection",
"url": "pgui_misc_logging.html#autoid_61",
"isFile": false,
"children": [
]
}
,
{
"title": "Logging categories",
"url": "pgui_misc_logging.html#autoid_62",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Using FreeMarker with servlets",
"url": "pgui_misc_servlet.html",
"isFile": true,
"children": [
{
"title": "“Model 2”",
"url": "pgui_misc_servlet.html#pgui_misc_servlet_model2",
"isFile": false,
"children": [
]
}
,
{
"title": "Including content from other web application\n resources",
"url": "pgui_misc_servlet.html#pgui_misc_servlet_include",
"isFile": false,
"children": [
]
}
,
{
"title": "Using JSP custom tags in FTL",
"url": "pgui_misc_servlet.html#autoid_63",
"isFile": false,
"children": [
]
}
,
{
"title": "Embed FTL into JSP pages",
"url": "pgui_misc_servlet.html#autoid_64",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Configuring security policy for FreeMarker",
"url": "pgui_misc_secureenv.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Legacy XML wrapper implementation",
"url": "pgui_misc_xml_legacy.html",
"isFile": true,
"children": [
{
"title": "TemplateScalarModel",
"url": "pgui_misc_xml_legacy.html#autoid_65",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateCollectionModel",
"url": "pgui_misc_xml_legacy.html#autoid_66",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateSequenceModel",
"url": "pgui_misc_xml_legacy.html#autoid_67",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateHashModel",
"url": "pgui_misc_xml_legacy.html#autoid_68",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateMethodModel",
"url": "pgui_misc_xml_legacy.html#autoid_69",
"isFile": false,
"children": [
]
}
,
{
"title": "Namespace handling",
"url": "pgui_misc_xml_legacy.html#autoid_70",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Using FreeMarker with Ant",
"url": "pgui_misc_ant.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Jython wrapper",
"url": "pgui_misc_jythonwrapper.html",
"isFile": true,
"children": [
{
"title": "TemplateHashModel functionality",
"url": "pgui_misc_jythonwrapper.html#autoid_71",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateScalarModel functionality",
"url": "pgui_misc_jythonwrapper.html#autoid_72",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateBooleanModel functionality",
"url": "pgui_misc_jythonwrapper.html#autoid_73",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateNumberModel functionality",
"url": "pgui_misc_jythonwrapper.html#autoid_74",
"isFile": false,
"children": [
]
}
,
{
"title": "TemplateSequenceModel functionality",
"url": "pgui_misc_jythonwrapper.html#autoid_75",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "Template Language Reference",
"url": "ref.html",
"isFile": true,
"children": [
{
"title": "Built-in Reference",
"url": "ref_builtins.html",
"isFile": true,
"children": [
{
"title": "Alphabetical index",
"url": "ref_builtins_alphaidx.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Built-ins for strings",
"url": "ref_builtins_string.html",
"isFile": true,
"children": [
{
"title": "boolean",
"url": "ref_builtins_string.html#ref_builtin_boolean",
"isFile": false,
"children": [
]
}
,
{
"title": "blank_to_null",
"url": "ref_builtins_string.html#ref_builtin_blank_to_null",
"isFile": false,
"children": [
]
}
,
{
"title": "cap_first",
"url": "ref_builtins_string.html#ref_builtin_cap_first",
"isFile": false,
"children": [
]
}
,
{
"title": "c (for string value)",
"url": "ref_builtins_string.html#ref_builtin_c_string",
"isFile": false,
"children": [
]
}
,
{
"title": "cn (for string value)",
"url": "ref_builtins_string.html#ref_builtin_cn_string",
"isFile": false,
"children": [
]
}
,
{
"title": "c_lower_case",
"url": "ref_builtins_string.html#ref_builtin_c_lower_case",
"isFile": false,
"children": [
]
}
,
{
"title": "c_upper_case",
"url": "ref_builtins_string.html#ref_builtin_c_upper_case",
"isFile": false,
"children": [
]
}
,
{
"title": "capitalize",
"url": "ref_builtins_string.html#ref_builtin_capitalize",
"isFile": false,
"children": [
]
}
,
{
"title": "chop_linebreak",
"url": "ref_builtins_string.html#ref_builtin_chop_linebreak",
"isFile": false,
"children": [
]
}
,
{
"title": "contains",
"url": "ref_builtins_string.html#ref_builtin_contains",
"isFile": false,
"children": [
]
}
,
{
"title": "date, time, datetime",
"url": "ref_builtins_string.html#ref_builtin_string_date",
"isFile": false,
"children": [
]
}
,
{
"title": "empty_to_null",
"url": "ref_builtins_string.html#ref_builtin_empty_to_null",
"isFile": false,
"children": [
]
}
,
{
"title": "ends_with",
"url": "ref_builtins_string.html#ref_builtin_ends_with",
"isFile": false,
"children": [
]
}
,
{
"title": "ensure_ends_with",
"url": "ref_builtins_string.html#ref_builtin_ensure_ends_with",
"isFile": false,
"children": [
]
}
,
{
"title": "ensure_starts_with",
"url": "ref_builtins_string.html#ref_builtin_ensure_starts_with",
"isFile": false,
"children": [
]
}
,
{
"title": "esc",
"url": "ref_builtins_string.html#ref_builtin_esc",
"isFile": false,
"children": [
]
}
,
{
"title": "groups",
"url": "ref_builtins_string.html#ref_builtin_groups",
"isFile": false,
"children": [
]
}
,
{
"title": "html (deprecated)",
"url": "ref_builtins_string.html#ref_builtin_html",
"isFile": false,
"children": [
]
}
,
{
"title": "index_of",
"url": "ref_builtins_string.html#ref_builtin_index_of",
"isFile": false,
"children": [
]
}
,
{
"title": "j_string",
"url": "ref_builtins_string.html#ref_builtin_j_string",
"isFile": false,
"children": [
]
}
,
{
"title": "js_string",
"url": "ref_builtins_string.html#ref_builtin_js_string",
"isFile": false,
"children": [
]
}
,
{
"title": "json_string",
"url": "ref_builtins_string.html#ref_builtin_json_string",
"isFile": false,
"children": [
]
}
,
{
"title": "keep_after",
"url": "ref_builtins_string.html#ref_builtin_keep_after",
"isFile": false,
"children": [
]
}
,
{
"title": "keep_after_last",
"url": "ref_builtins_string.html#ref_builtin_keep_after_last",
"isFile": false,
"children": [
]
}
,
{
"title": "keep_before",
"url": "ref_builtins_string.html#ref_builtin_keep_before",
"isFile": false,
"children": [
]
}
,
{
"title": "keep_before_last",
"url": "ref_builtins_string.html#ref_builtin_keep_before_last",
"isFile": false,
"children": [
]
}
,
{
"title": "last_index_of",
"url": "ref_builtins_string.html#ref_builtin_last_index_of",
"isFile": false,
"children": [
]
}
,
{
"title": "left_pad",
"url": "ref_builtins_string.html#ref_builtin_left_pad",
"isFile": false,
"children": [
]
}
,
{
"title": "length",
"url": "ref_builtins_string.html#ref_builtin_length",
"isFile": false,
"children": [
]
}
,
{
"title": "lower_case",
"url": "ref_builtins_string.html#ref_builtin_lower_case",
"isFile": false,
"children": [
]
}
,
{
"title": "matches",
"url": "ref_builtins_string.html#ref_builtin_matches",
"isFile": false,
"children": [
]
}
,
{
"title": "no_esc",
"url": "ref_builtins_string.html#ref_builtin_no_esc",
"isFile": false,
"children": [
]
}
,
{
"title": "number",
"url": "ref_builtins_string.html#ref_builtin_number",
"isFile": false,
"children": [
]
}
,
{
"title": "replace",
"url": "ref_builtins_string.html#ref_builtin_replace",
"isFile": false,
"children": [
]
}
,
{
"title": "right_pad",
"url": "ref_builtins_string.html#ref_builtin_right_pad",
"isFile": false,
"children": [
]
}
,
{
"title": "remove_beginning",
"url": "ref_builtins_string.html#ref_builtin_remove_beginning",
"isFile": false,
"children": [
]
}
,
{
"title": "remove_ending",
"url": "ref_builtins_string.html#ref_builtin_remove_ending",
"isFile": false,
"children": [
]
}
,
{
"title": "rtf (deprecated)",
"url": "ref_builtins_string.html#ref_builtin_rtf",
"isFile": false,
"children": [
]
}
,
{
"title": "split",
"url": "ref_builtins_string.html#ref_builtin_split",
"isFile": false,
"children": [
]
}
,
{
"title": "starts_with",
"url": "ref_builtins_string.html#ref_builtin_starts_with",
"isFile": false,
"children": [
]
}
,
{
"title": "string (when used with a string value)",
"url": "ref_builtins_string.html#ref_builtin_string_for_string",
"isFile": false,
"children": [
]
}
,
{
"title": "substring (deprecated)",
"url": "ref_builtins_string.html#ref_builtin_substring",
"isFile": false,
"children": [
]
}
,
{
"title": "trim",
"url": "ref_builtins_string.html#ref_builtin_trim",
"isFile": false,
"children": [
]
}
,
{
"title": "trim_to_null",
"url": "ref_builtins_string.html#ref_builtin_trim_to_null",
"isFile": false,
"children": [
]
}
,
{
"title": "truncate, truncate_...",
"url": "ref_builtins_string.html#ref_builtin_truncate",
"isFile": false,
"children": [
]
}
,
{
"title": "uncap_first",
"url": "ref_builtins_string.html#ref_builtin_uncap_first",
"isFile": false,
"children": [
]
}
,
{
"title": "upper_case",
"url": "ref_builtins_string.html#ref_builtin_upper_case",
"isFile": false,
"children": [
]
}
,
{
"title": "url",
"url": "ref_builtins_string.html#ref_builtin_url",
"isFile": false,
"children": [
]
}
,
{
"title": "url_path",
"url": "ref_builtins_string.html#ref_builtin_url_path",
"isFile": false,
"children": [
]
}
,
{
"title": "word_list",
"url": "ref_builtins_string.html#ref_builtin_word_list",
"isFile": false,
"children": [
]
}
,
{
"title": "xhtml (deprecated)",
"url": "ref_builtins_string.html#ref_builtin_xhtml",
"isFile": false,
"children": [
]
}
,
{
"title": "xml (deprecated)",
"url": "ref_builtins_string.html#ref_builtin_xml",
"isFile": false,
"children": [
]
}
,
{
"title": "Common flags",
"url": "ref_builtins_string.html#ref_builtin_string_flags",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for numbers",
"url": "ref_builtins_number.html",
"isFile": true,
"children": [
{
"title": "abs",
"url": "ref_builtins_number.html#ref_builtin_abs",
"isFile": false,
"children": [
]
}
,
{
"title": "c (for numbers)",
"url": "ref_builtins_number.html#ref_builtin_c",
"isFile": false,
"children": [
]
}
,
{
"title": "cn (for numbers)",
"url": "ref_builtins_number.html#ref_builtin_cn",
"isFile": false,
"children": [
]
}
,
{
"title": "is_infinite",
"url": "ref_builtins_number.html#ref_builtin_is_infinite",
"isFile": false,
"children": [
]
}
,
{
"title": "is_nan",
"url": "ref_builtins_number.html#ref_builtin_is_nan",
"isFile": false,
"children": [
]
}
,
{
"title": "lower_abc",
"url": "ref_builtins_number.html#ref_builtin_lower_abc",
"isFile": false,
"children": [
]
}
,
{
"title": "round, floor, ceiling",
"url": "ref_builtins_number.html#ref_builtin_rounding",
"isFile": false,
"children": [
]
}
,
{
"title": "string (when used with a numerical value)",
"url": "ref_builtins_number.html#ref_builtin_string_for_number",
"isFile": false,
"children": [
]
}
,
{
"title": "upper_abc",
"url": "ref_builtins_number.html#ref_builtin_upper_abc",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for date/time/date-time values",
"url": "ref_builtins_date.html",
"isFile": true,
"children": [
{
"title": "date, time, datetime (when used with a date/time/date-time\n value)",
"url": "ref_builtins_date.html#ref_builtin_date_datetype",
"isFile": false,
"children": [
]
}
,
{
"title": "date_if_unknown, time_if_unknown, datetime_if_unknown",
"url": "ref_builtins_date.html#ref_builtin_date_if_unknown",
"isFile": false,
"children": [
]
}
,
{
"title": "iso_...",
"url": "ref_builtins_date.html#ref_builtin_date_iso",
"isFile": false,
"children": [
]
}
,
{
"title": "string (when used with a date/time/date-time value)",
"url": "ref_builtins_date.html#ref_builtin_string_for_date",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for booleans",
"url": "ref_builtins_boolean.html",
"isFile": true,
"children": [
{
"title": "c (for boolean value)",
"url": "ref_builtins_boolean.html#ref_builtin_c_boolean",
"isFile": false,
"children": [
]
}
,
{
"title": "cn (for boolean value)",
"url": "ref_builtins_boolean.html#ref_builtin_cn_boolean",
"isFile": false,
"children": [
]
}
,
{
"title": "string (when used with a boolean value)",
"url": "ref_builtins_boolean.html#ref_builtin_string_for_boolean",
"isFile": false,
"children": [
]
}
,
{
"title": "then",
"url": "ref_builtins_boolean.html#ref_builtin_then",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for sequences",
"url": "ref_builtins_sequence.html",
"isFile": true,
"children": [
{
"title": "chunk",
"url": "ref_builtins_sequence.html#ref_builtin_chunk",
"isFile": false,
"children": [
]
}
,
{
"title": "drop_while",
"url": "ref_builtins_sequence.html#ref_builtin_drop_while",
"isFile": false,
"children": [
]
}
,
{
"title": "filter",
"url": "ref_builtins_sequence.html#ref_builtin_filter",
"isFile": false,
"children": [
]
}
,
{
"title": "first",
"url": "ref_builtins_sequence.html#ref_builtin_first",
"isFile": false,
"children": [
]
}
,
{
"title": "join",
"url": "ref_builtins_sequence.html#ref_builtin_join",
"isFile": false,
"children": [
]
}
,
{
"title": "last",
"url": "ref_builtins_sequence.html#ref_builtin_last",
"isFile": false,
"children": [
]
}
,
{
"title": "map",
"url": "ref_builtins_sequence.html#ref_builtin_map",
"isFile": false,
"children": [
]
}
,
{
"title": "min, max",
"url": "ref_builtins_sequence.html#ref_builtin_min_max",
"isFile": false,
"children": [
]
}
,
{
"title": "reverse",
"url": "ref_builtins_sequence.html#ref_builtin_reverse",
"isFile": false,
"children": [
]
}
,
{
"title": "seq_contains",
"url": "ref_builtins_sequence.html#ref_builtin_seq_contains",
"isFile": false,
"children": [
]
}
,
{
"title": "seq_index_of",
"url": "ref_builtins_sequence.html#ref_builtin_seq_index_of",
"isFile": false,
"children": [
]
}
,
{
"title": "seq_last_index_of",
"url": "ref_builtins_sequence.html#ref_builtin_seq_last_index_of",
"isFile": false,
"children": [
]
}
,
{
"title": "size",
"url": "ref_builtins_sequence.html#ref_builtin_size",
"isFile": false,
"children": [
]
}
,
{
"title": "sort",
"url": "ref_builtins_sequence.html#ref_builtin_sort",
"isFile": false,
"children": [
]
}
,
{
"title": "sort_by",
"url": "ref_builtins_sequence.html#ref_builtin_sort_by",
"isFile": false,
"children": [
]
}
,
{
"title": "take_while",
"url": "ref_builtins_sequence.html#ref_builtin_take_while",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for hashes",
"url": "ref_builtins_hash.html",
"isFile": true,
"children": [
{
"title": "keys",
"url": "ref_builtins_hash.html#ref_builtin_keys",
"isFile": false,
"children": [
]
}
,
{
"title": "values",
"url": "ref_builtins_hash.html#ref_builtin_values",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Built-ins for nodes (for XML)",
"url": "ref_builtins_node.html",
"isFile": true,
"children": [
{
"title": "ancestors",
"url": "ref_builtins_node.html#ref_builtin_ancestors",
"isFile": false,
"children": [
]
}
,
{
"title": "children",
"url": "ref_builtins_node.html#ref_builtin_children",
"isFile": false,
"children": [
]
}
,
{
"title": "node_name",
"url": "ref_builtins_node.html#ref_builtin_node_name",
"isFile": false,
"children": [
]
}
,
{
"title": "next_sibling",
"url": "ref_builtins_node.html#ref_builtin_next_sibling",
"isFile": false,
"children": [
]
}
,
{
"title": "node_namespace",
"url": "ref_builtins_node.html#ref_builtin_node_namespace",
"isFile": false,
"children": [
]
}
,
{
"title": "node_type",
"url": "ref_builtins_node.html#ref_builtin_node_type",
"isFile": false,
"children": [
]
}
,
{
"title": "parent",
"url": "ref_builtins_node.html#ref_builtin_parent",
"isFile": false,
"children": [
]
}
,
{
"title": "previous_sibling",
"url": "ref_builtins_node.html#ref_builtin_previous_sibling",
"isFile": false,
"children": [
]
}
,
{
"title": "root",
"url": "ref_builtins_node.html#ref_builtin_root",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Loop variable built-ins",
"url": "ref_builtins_loop_var.html",
"isFile": true,
"children": [
{
"title": "counter",
"url": "ref_builtins_loop_var.html#ref_builtin_counter",
"isFile": false,
"children": [
]
}
,
{
"title": "has_next",
"url": "ref_builtins_loop_var.html#ref_builtin_has_next",
"isFile": false,
"children": [
]
}
,
{
"title": "index",
"url": "ref_builtins_loop_var.html#ref_builtin_index",
"isFile": false,
"children": [
]
}
,
{
"title": "is_even_item",
"url": "ref_builtins_loop_var.html#ref_builtin_is_even_item",
"isFile": false,
"children": [
]
}
,
{
"title": "is_first",
"url": "ref_builtins_loop_var.html#ref_builtin_is_first",
"isFile": false,
"children": [
]
}
,
{
"title": "is_last",
"url": "ref_builtins_loop_var.html#ref_builtin_is_last",
"isFile": false,
"children": [
]
}
,
{
"title": "is_odd_item",
"url": "ref_builtins_loop_var.html#ref_builtin_is_odd_item",
"isFile": false,
"children": [
]
}
,
{
"title": "item_cycle",
"url": "ref_builtins_loop_var.html#ref_builtin_item_cycle",
"isFile": false,
"children": [
]
}
,
{
"title": "item_parity",
"url": "ref_builtins_loop_var.html#ref_builtin_item_parity",
"isFile": false,
"children": [
]
}
,
{
"title": "item_parity_cap",
"url": "ref_builtins_loop_var.html#ref_builtin_item_parity_cap",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Type independent built-ins",
"url": "ref_builtins_type_independent.html",
"isFile": true,
"children": [
{
"title": "switch",
"url": "ref_builtins_type_independent.html#ref_builtin_switch",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Seldom used and expert built-ins",
"url": "ref_builtins_expert.html",
"isFile": true,
"children": [
{
"title": "absolute_template_name",
"url": "ref_builtins_expert.html#ref_builtin_absolute_template_name",
"isFile": false,
"children": [
]
}
,
{
"title": "api, has_api",
"url": "ref_builtins_expert.html#ref_buitin_api_and_has_api",
"isFile": false,
"children": [
]
}
,
{
"title": "byte, double, float, int, long, short",
"url": "ref_builtins_expert.html#ref_builtin_numType",
"isFile": false,
"children": [
]
}
,
{
"title": "eval",
"url": "ref_builtins_expert.html#ref_builtin_eval",
"isFile": false,
"children": [
]
}
,
{
"title": "eval_json",
"url": "ref_builtins_expert.html#ref_builtin_eval_json",
"isFile": false,
"children": [
]
}
,
{
"title": "has_content",
"url": "ref_builtins_expert.html#ref_builtin_has_content",
"isFile": false,
"children": [
]
}
,
{
"title": "interpret",
"url": "ref_builtins_expert.html#ref_builtin_interpret",
"isFile": false,
"children": [
]
}
,
{
"title": "is_...",
"url": "ref_builtins_expert.html#ref_builtin_isType",
"isFile": false,
"children": [
]
}
,
{
"title": "markup_string",
"url": "ref_builtins_expert.html#ref_builtin_markup_string",
"isFile": false,
"children": [
]
}
,
{
"title": "namespace",
"url": "ref_builtins_expert.html#ref_builtin_namespace",
"isFile": false,
"children": [
]
}
,
{
"title": "new",
"url": "ref_builtins_expert.html#ref_builtin_new",
"isFile": false,
"children": [
]
}
,
{
"title": "number_to_date, number_to_time, number_to_datetime",
"url": "ref_builtins_expert.html#ref_builtin_numToDate",
"isFile": false,
"children": [
]
}
,
{
"title": "sequence",
"url": "ref_builtins_expert.html#ref_builtin_sequence",
"isFile": false,
"children": [
]
}
,
{
"title": "with_args",
"url": "ref_builtins_expert.html#ref_builtin_with_args",
"isFile": false,
"children": [
]
}
,
{
"title": "with_args_last",
"url": "ref_builtins_expert.html#ref_builtin_with_args_last",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Directive Reference",
"url": "ref_directives.html",
"isFile": true,
"children": [
{
"title": "Alphabetical index",
"url": "ref_directive_alphaidx.html",
"isFile": true,
"children": [
]
}
,
{
"title": "assign",
"url": "ref_directive_assign.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_assign.html#autoid_78",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_assign.html#autoid_79",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "attempt, recover",
"url": "ref_directive_attempt.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_attempt.html#autoid_80",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_attempt.html#autoid_81",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "autoesc",
"url": "ref_directive_autoesc.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_autoesc.html#autoid_82",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_autoesc.html#autoid_83",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "compress",
"url": "ref_directive_compress.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_compress.html#autoid_84",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_compress.html#autoid_85",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "escape, noescape (deprecated)",
"url": "ref_directive_escape.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_escape.html#autoid_86",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_escape.html#autoid_87",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "flush",
"url": "ref_directive_flush.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_flush.html#autoid_88",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_flush.html#autoid_89",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "ftl",
"url": "ref_directive_ftl.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_ftl.html#autoid_90",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_ftl.html#autoid_91",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "function, return",
"url": "ref_directive_function.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_function.html#autoid_92",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_function.html#autoid_93",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "global",
"url": "ref_directive_global.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_global.html#autoid_94",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_global.html#autoid_95",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "if, else, elseif",
"url": "ref_directive_if.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_if.html#autoid_96",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_if.html#autoid_97",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "import",
"url": "ref_directive_import.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_import.html#autoid_98",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_import.html#autoid_99",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "include",
"url": "ref_directive_include.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_include.html#autoid_100",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_include.html#autoid_101",
"isFile": false,
"children": [
{
"title": "Using acquisition",
"url": "ref_directive_include.html#ref_directive_include_acquisition",
"isFile": false,
"children": [
]
}
,
{
"title": "Localized lookup",
"url": "ref_directive_include.html#ref_directive_include_localized",
"isFile": false,
"children": [
]
}
,
{
"title": "Why import should be used instead of\n include",
"url": "ref_directive_include.html#topic.import_vs_include",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "list, else, items, sep, break, continue",
"url": "ref_directive_list.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_list.html#autoid_102",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_list.html#autoid_103",
"isFile": false,
"children": [
{
"title": "Simplest form",
"url": "ref_directive_list.html#ref_list_simple",
"isFile": false,
"children": [
]
}
,
{
"title": "else directive",
"url": "ref_directive_list.html#ref_list_else",
"isFile": false,
"children": [
]
}
,
{
"title": "items directive",
"url": "ref_directive_list.html#ref_list_items",
"isFile": false,
"children": [
]
}
,
{
"title": "sep directive",
"url": "ref_directive_list.html#ref_list_sep",
"isFile": false,
"children": [
]
}
,
{
"title": "break directive",
"url": "ref_directive_list.html#ref_list_break",
"isFile": false,
"children": [
]
}
,
{
"title": "continue directive",
"url": "ref_directive_list.html#ref_list_continue",
"isFile": false,
"children": [
]
}
,
{
"title": "Accessing iteration state",
"url": "ref_directive_list.html#ref_list_accessing_state",
"isFile": false,
"children": [
]
}
,
{
"title": "Skipping items conditionally",
"url": "ref_directive_list.html#ref_list_skipping",
"isFile": false,
"children": [
]
}
,
{
"title": "Nesting loops into each other",
"url": "ref_directive_list.html#ref_list_nesting",
"isFile": false,
"children": [
]
}
,
{
"title": "Treatment of missing (null) elements",
"url": "ref_directive_list.html#ref_list_missing_element",
"isFile": false,
"children": [
]
}
,
{
"title": "Notes for Java programmers",
"url": "ref_directive_list.html#ref_list_java_notes",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "local",
"url": "ref_directive_local.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_local.html#autoid_106",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_local.html#autoid_107",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "macro, nested, return",
"url": "ref_directive_macro.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_macro.html#autoid_108",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_macro.html#autoid_109",
"isFile": false,
"children": [
{
"title": "nested",
"url": "ref_directive_macro.html#autoid_110",
"isFile": false,
"children": [
]
}
,
{
"title": "return",
"url": "ref_directive_macro.html#autoid_111",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "noautoesc",
"url": "ref_directive_noautoesc.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_noautoesc.html#autoid_112",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_noautoesc.html#autoid_113",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "noparse",
"url": "ref_directive_noparse.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_noparse.html#autoid_114",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_noparse.html#autoid_115",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "nt",
"url": "ref_directive_nt.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_nt.html#autoid_116",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_nt.html#autoid_117",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "outputformat",
"url": "ref_directive_outputformat.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_outputformat.html#autoid_118",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_outputformat.html#autoid_119",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "setting",
"url": "ref_directive_setting.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_setting.html#autoid_120",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_setting.html#autoid_121",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "stop",
"url": "ref_directive_stop.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_stop.html#autoid_122",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_stop.html#autoid_123",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "switch, on, case, default, break",
"url": "ref_directive_switch.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_switch.html#autoid_124",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_switch.html#autoid_125",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "t, lt, rt",
"url": "ref_directive_t.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_t.html#autoid_126",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_t.html#autoid_127",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "User-defined directive (<@...>)",
"url": "ref_directive_userDefined.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_userDefined.html#autoid_128",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_userDefined.html#autoid_129",
"isFile": false,
"children": [
{
"title": "End-tag",
"url": "ref_directive_userDefined.html#ref_directive_userDefined_entTag",
"isFile": false,
"children": [
]
}
,
{
"title": "Loop variables",
"url": "ref_directive_userDefined.html#ref_directive_userDefined_loopVar",
"isFile": false,
"children": [
]
}
,
{
"title": "Positional parameter passing",
"url": "ref_directive_userDefined.html#ref_directive_userDefined_positionalParam",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "visit, recurse, fallback",
"url": "ref_directive_visit.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_directive_visit.html#autoid_130",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_directive_visit.html#autoid_131",
"isFile": false,
"children": [
{
"title": "Visit",
"url": "ref_directive_visit.html#autoid_132",
"isFile": false,
"children": [
]
}
,
{
"title": "Recurse",
"url": "ref_directive_visit.html#autoid_133",
"isFile": false,
"children": [
]
}
,
{
"title": "Fallback",
"url": "ref_directive_visit.html#autoid_134",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "Special Variable Reference",
"url": "ref_specvar.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Reserved names in FTL",
"url": "ref_reservednames.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Deprecated FTL constructs",
"url": "ref_deprecated.html",
"isFile": true,
"children": [
{
"title": "List of deprecated directives",
"url": "ref_depr_directive.html",
"isFile": true,
"children": [
]
}
,
{
"title": "List of deprecated built-ins",
"url": "ref_depr_builtin.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Old-style macro and call directives",
"url": "ref_depr_oldmacro.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_depr_oldmacro.html#autoid_135",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_depr_oldmacro.html#autoid_136",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Transform directive",
"url": "ref_depr_transform.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_depr_transform.html#autoid_137",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_depr_transform.html#autoid_138",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Old FTL syntax",
"url": "ref_depr_oldsyntax.html",
"isFile": true,
"children": [
]
}
,
{
"title": "#{...}: Numerical interpolation",
"url": "ref_depr_numerical_interpolation.html",
"isFile": true,
"children": [
{
"title": "Synopsis",
"url": "ref_depr_numerical_interpolation.html#autoid_139",
"isFile": false,
"children": [
]
}
,
{
"title": "Description",
"url": "ref_depr_numerical_interpolation.html#autoid_140",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "XML Processing Guide",
"url": "xgui.html",
"isFile": true,
"children": [
{
"title": "Preface",
"url": "xgui_preface.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Exposing XML documents",
"url": "xgui_expose.html",
"isFile": true,
"children": [
{
"title": "The DOM tree",
"url": "xgui_expose_dom.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Putting the XML into the data-model",
"url": "xgui_expose_put.html",
"isFile": true,
"children": [
]
}
]
}
,
{
"title": "Imperative XML processing",
"url": "xgui_imperative.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "xgui_imperative_learn.html",
"isFile": true,
"children": [
{
"title": "Accessing elements by name",
"url": "xgui_imperative_learn.html#autoid_141",
"isFile": false,
"children": [
]
}
,
{
"title": "Accessing attributes",
"url": "xgui_imperative_learn.html#autoid_142",
"isFile": false,
"children": [
]
}
,
{
"title": "Exploring the tree",
"url": "xgui_imperative_learn.html#autoid_143",
"isFile": false,
"children": [
]
}
,
{
"title": "Using XPath expressions",
"url": "xgui_imperative_learn.html#xgui_imperative_learn_xpath",
"isFile": false,
"children": [
]
}
,
{
"title": "XML namespaces",
"url": "xgui_imperative_learn.html#autoid_144",
"isFile": false,
"children": [
]
}
,
{
"title": "Don't forget escaping!",
"url": "xgui_imperative_learn.html#autoid_145",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "Details",
"url": "xgui_imperative_formal.html",
"isFile": true,
"children": [
{
"title": "Node sequences",
"url": "xgui_imperative_formal.html#autoid_146",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Declarative XML processing",
"url": "xgui_declarative.html",
"isFile": true,
"children": [
{
"title": "Basics",
"url": "xgui_declarative_basics.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Details",
"url": "xgui_declarative_details.html",
"isFile": true,
"children": [
{
"title": "Default handlers",
"url": "xgui_declarative_details.html#autoid_147",
"isFile": false,
"children": [
]
}
,
{
"title": "Visiting a single node",
"url": "xgui_declarative_details.html#autoid_148",
"isFile": false,
"children": [
]
}
,
{
"title": "XML namespaces",
"url": "xgui_declarative_details.html#autoid_149",
"isFile": false,
"children": [
]
}
]
}
]
}
]
}
,
{
"title": "Appendixes",
"url": "app.html",
"isFile": true,
"children": [
{
"title": "FAQ",
"url": "app_faq.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Version history",
"url": "app_versions.html",
"isFile": true,
"children": [
{
"title": "2.3.34",
"url": "versions_2_3_34.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_34.html#autoid_150",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_34.html#autoid_151",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.33",
"url": "versions_2_3_33.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_33.html#autoid_152",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_33.html#version_hisotry_freemarker_183_java_side",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.32",
"url": "versions_2_3_32.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_32.html#autoid_153",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_32.html#autoid_154",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.31",
"url": "versions_2_3_31.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_31.html#autoid_155",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_31.html#autoid_156",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.30",
"url": "versions_2_3_30.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_30.html#autoid_157",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_30.html#autoid_158",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.29",
"url": "versions_2_3_29.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_29.html#autoid_159",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_29.html#autoid_160",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.28",
"url": "versions_2_3_28.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_28.html#autoid_161",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_28.html#autoid_162",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_28.html#autoid_163",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.27 (incubating at Apache)",
"url": "versions_2_3_27.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_27.html#autoid_164",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_27.html#autoid_165",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.26 (incubating at Apache)",
"url": "versions_2_3_26.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_26.html#autoid_166",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_26.html#autoid_167",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_26.html#autoid_168",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.25 (incubating at Apache)",
"url": "versions_2_3_25.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_25.html#autoid_169",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_25.html#autoid_170",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.24 (incubating at Apache)",
"url": "versions_2_3_24.html",
"isFile": true,
"children": [
{
"title": "Legal changes",
"url": "versions_2_3_24.html#autoid_171",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_24.html#autoid_172",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_24.html#autoid_173",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes compared to 2.3.24 Release Candidate 1",
"url": "versions_2_3_24.html#autoid_174",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.23",
"url": "versions_2_3_23.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_23.html#autoid_175",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_23.html#autoid_176",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_23.html#autoid_177",
"isFile": false,
"children": [
]
}
,
{
"title": "Notes",
"url": "versions_2_3_23.html#autoid_178",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.22",
"url": "versions_2_3_22.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_22.html#autoid_179",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_22.html#autoid_180",
"isFile": false,
"children": [
]
}
,
{
"title": "Notes",
"url": "versions_2_3_22.html#autoid_181",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.21",
"url": "versions_2_3_21.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_21.html#autoid_182",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_21.html#autoid_183",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_21.html#autoid_184",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.20",
"url": "versions_2_3_20.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_20.html#autoid_185",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_20.html#autoid_186",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_20.html#autoid_187",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.19",
"url": "versions_2_3_19.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_19.html#autoid_188",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_19.html#autoid_189",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.18",
"url": "versions_2_3_18.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_18.html#autoid_190",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_18.html#autoid_191",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.17",
"url": "versions_2_3_17.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_17.html#autoid_192",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_17.html#autoid_193",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_17.html#autoid_194",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.16",
"url": "versions_2_3_16.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_16.html#autoid_195",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_16.html#autoid_196",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.15",
"url": "versions_2_3_15.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_15.html#autoid_197",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_15.html#autoid_198",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.14",
"url": "versions_2_3_14.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_14.html#autoid_199",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_14.html#autoid_200",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.13",
"url": "versions_2_3_13.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_13.html#autoid_201",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_13.html#autoid_202",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.12",
"url": "versions_2_3_12.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_12.html#autoid_203",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.11",
"url": "versions_2_3_11.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_11.html#autoid_204",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_11.html#autoid_205",
"isFile": false,
"children": [
]
}
,
{
"title": "Documentation changes",
"url": "versions_2_3_11.html#autoid_206",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.10",
"url": "versions_2_3_10.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_10.html#autoid_207",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_10.html#autoid_208",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.9",
"url": "versions_2_3_9.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_9.html#autoid_209",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.8",
"url": "versions_2_3_8.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_8.html#autoid_210",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.7",
"url": "versions_2_3_7.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_7.html#autoid_211",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_7.html#autoid_212",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.7 RC1",
"url": "versions_2_3_7rc1.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_7rc1.html#autoid_213",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_7rc1.html#autoid_214",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.6",
"url": "versions_2_3_6.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_6.html#autoid_215",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.5",
"url": "versions_2_3_5.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_5.html#autoid_216",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_5.html#autoid_217",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.4",
"url": "versions_2_3_4.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_4.html#autoid_218",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_4.html#autoid_219",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_4.html#autoid_220",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.3",
"url": "versions_2_3_3.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_3_3.html#autoid_221",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_3.html#autoid_222",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_3.html#autoid_223",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.2",
"url": "versions_2_3_2.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_3_2.html#autoid_224",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.3.1",
"url": "versions_2_3_1.html",
"isFile": true,
"children": [
{
"title": "Possible backward compatibility issue",
"url": "versions_2_3_1.html#autoid_225",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3_1.html#autoid_226",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3_1.html#autoid_227",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3_1.html#autoid_228",
"isFile": false,
"children": [
]
}
,
{
"title": "The history of the releases before the final version",
"url": "versions_2_3_1.html#autoid_229",
"isFile": false,
"children": [
{
"title": "Differences between the preview release and final\n release",
"url": "versions_2_3_1.html#autoid_230",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "2.3",
"url": "versions_2_3.html",
"isFile": true,
"children": [
{
"title": "Non backward-compatible changes!",
"url": "versions_2_3.html#autoid_231",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the FTL side",
"url": "versions_2_3.html#autoid_232",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_3.html#autoid_233",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_3.html#autoid_234",
"isFile": false,
"children": [
]
}
,
{
"title": "The history of the releases before the final version",
"url": "versions_2_3.html#autoid_235",
"isFile": false,
"children": [
{
"title": "Differences between the final release and Release Candidate\n 4",
"url": "versions_2_3.html#autoid_236",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Release Candidate 4 and Release\n Candidate 3",
"url": "versions_2_3.html#autoid_237",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Release Candidate 3 and Release\n Candidate 2",
"url": "versions_2_3.html#autoid_238",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Release Candidate 2 and Release\n Candidate 1",
"url": "versions_2_3.html#autoid_239",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Release Candidate 1 and Preview 16\n releases",
"url": "versions_2_3.html#autoid_240",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 16 and Preview 15\n releases",
"url": "versions_2_3.html#autoid_241",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 15 and Preview 14\n releases",
"url": "versions_2_3.html#autoid_242",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 14 and Preview 13\n releases",
"url": "versions_2_3.html#autoid_243",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 13 and Preview 12\n releases",
"url": "versions_2_3.html#autoid_244",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 12 and Preview 11\n releases",
"url": "versions_2_3.html#autoid_245",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 11 and Preview 10\n releases",
"url": "versions_2_3.html#autoid_246",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 10 and Preview 9\n releases",
"url": "versions_2_3.html#autoid_247",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 9 and Preview 8\n releases",
"url": "versions_2_3.html#autoid_248",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 8 and Preview 7\n releases",
"url": "versions_2_3.html#autoid_249",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 7 and Preview 6\n releases",
"url": "versions_2_3.html#autoid_250",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 6 and Preview 5\n releases",
"url": "versions_2_3.html#autoid_251",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 5 and Preview 4\n releases",
"url": "versions_2_3.html#autoid_252",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 4 and Preview 3\n releases",
"url": "versions_2_3.html#autoid_253",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 3 and Preview 2\n releases",
"url": "versions_2_3.html#autoid_254",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 2 and Preview 1\n releases",
"url": "versions_2_3.html#autoid_255",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "2.2.8",
"url": "versions_2_2_8.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_2_8.html#autoid_256",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_2_8.html#autoid_257",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_2_8.html#autoid_258",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.7",
"url": "versions_2_2_7.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_2_7.html#autoid_259",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.6",
"url": "versions_2_2_6.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_2_6.html#autoid_260",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_2_6.html#autoid_261",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_2_6.html#autoid_262",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.5",
"url": "versions_2_2_5.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_2_5.html#autoid_263",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.4",
"url": "versions_2_2_4.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_2_4.html#autoid_264",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_2_4.html#autoid_265",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.3",
"url": "versions_2_2_3.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_2_3.html#autoid_266",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_2_3.html#autoid_267",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.2",
"url": "versions_2_2_2.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_2_2.html#autoid_268",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2.1",
"url": "versions_2_2_1.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_2_1.html#autoid_269",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_2_1.html#autoid_270",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.2",
"url": "versions_2_2.html",
"isFile": true,
"children": [
{
"title": "Non backward-compatible changes!",
"url": "versions_2_2.html#autoid_271",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes in FTL (FreeMarker Template Language)",
"url": "versions_2_2.html#autoid_272",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_2.html#autoid_273",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_2.html#autoid_274",
"isFile": false,
"children": [
]
}
,
{
"title": "The history of the releases before the final version",
"url": "versions_2_2.html#autoid_275",
"isFile": false,
"children": [
{
"title": "Differences between the final and RC2 releases",
"url": "versions_2_2.html#autoid_276",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the RC2 and RC1 releases",
"url": "versions_2_2.html#autoid_277",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 2 and RC1 releases",
"url": "versions_2_2.html#autoid_278",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the Preview 1 and Preview 2\n releases",
"url": "versions_2_2.html#autoid_279",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "2.1.5",
"url": "versions_2_1_5.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_1_5.html#autoid_280",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.1.4",
"url": "versions_2_1_4.html",
"isFile": true,
"children": [
{
"title": "Changes on the Java side",
"url": "versions_2_1_4.html#autoid_281",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.1.3",
"url": "versions_2_1_3.html",
"isFile": true,
"children": [
{
"title": "Changes on the FTL side",
"url": "versions_2_1_3.html#autoid_282",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_1_3.html#autoid_283",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.1.2",
"url": "versions_2_1_2.html",
"isFile": true,
"children": [
{
"title": "Changes in FTL (FreeMarker Template Language)",
"url": "versions_2_1_2.html#autoid_284",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_1_2.html#autoid_285",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.1.1",
"url": "versions_2_1_1.html",
"isFile": true,
"children": [
{
"title": "Changes in FTL (FreeMarker Template Language)",
"url": "versions_2_1_1.html#autoid_286",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_1_1.html#autoid_287",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.1",
"url": "versions_2_1.html",
"isFile": true,
"children": [
{
"title": "Changes in FTL (FreeMarker Template Language)",
"url": "versions_2_1.html#autoid_288",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes on the Java side",
"url": "versions_2_1.html#autoid_289",
"isFile": false,
"children": [
]
}
,
{
"title": "Other changes",
"url": "versions_2_1.html#autoid_290",
"isFile": false,
"children": [
]
}
,
{
"title": "Differences between the RC1 and final release",
"url": "versions_2_1.html#autoid_291",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.01",
"url": "versions_2_01.html",
"isFile": true,
"children": [
]
}
,
{
"title": "2.0",
"url": "versions_2_0.html",
"isFile": true,
"children": [
{
"title": "Bugfixes",
"url": "versions_2_0.html#autoid_292",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes to the Template language",
"url": "versions_2_0.html#autoid_293",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes to the API",
"url": "versions_2_0.html#autoid_294",
"isFile": false,
"children": [
]
}
,
{
"title": "Miscellany",
"url": "versions_2_0.html#autoid_295",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.0 RC3",
"url": "versions_2_0RC3.html",
"isFile": true,
"children": [
{
"title": "Bug Fixes",
"url": "versions_2_0RC3.html#autoid_296",
"isFile": false,
"children": [
]
}
,
{
"title": "Changes to the Template Language",
"url": "versions_2_0RC3.html#autoid_297",
"isFile": false,
"children": [
]
}
,
{
"title": "API changes",
"url": "versions_2_0RC3.html#autoid_298",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.0 RC2",
"url": "versions_2_0RC2.html",
"isFile": true,
"children": [
{
"title": "Changes to Template Language",
"url": "versions_2_0RC2.html#autoid_299",
"isFile": false,
"children": [
]
}
,
{
"title": "API Changes",
"url": "versions_2_0RC2.html#autoid_300",
"isFile": false,
"children": [
]
}
]
}
,
{
"title": "2.0 RC1",
"url": "versions_2_0RC1.html",
"isFile": true,
"children": [
{
"title": "Support for Numerical operations, both arithmetic and\n boolean, as well as numerical ranges.",
"url": "versions_2_0RC1.html#autoid_301",
"isFile": false,
"children": [
]
}
,
{
"title": "API Changes",
"url": "versions_2_0RC1.html#autoid_302",
"isFile": false,
"children": [
]
}
,
{
"title": "Syntactical Miscellany",
"url": "versions_2_0RC1.html#autoid_303",
"isFile": false,
"children": [
]
}
]
}
]
}
,
{
"title": "Installing FreeMarker",
"url": "app_install.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Legal",
"url": "app_legal.html",
"isFile": true,
"children": [
{
"title": "License",
"url": "app_license.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Export Control",
"url": "app_eccn.html",
"isFile": true,
"children": [
]
}
]
}
]
}
,
{
"title": "Glossary",
"url": "gloss.html",
"isFile": true,
"children": [
]
}
,
{
"title": "Alphabetical Index",
"url": "alphaidx.html",
"isFile": true,
"children": [
]
}
]
}
;
