---
title: Time Travel
weight: 18
type: docs
---
<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Time Travel

{{< label Batch >}} {{< label Streaming >}}

The syntax of `time travel` is used for querying historical data. It allows users to specify a point in time and query the corresponding table data.

<span class="label label-danger">Attention</span> Currently, `time travel` requires the corresponding catalog that the table belongs to implementing the {{< gh_link file="flink-table/flink-table-common/src/main/java/org/apache/flink/table/catalog/Catalog.java" name="getTable(ObjectPath tablePath, long timestamp)" >}} method.
See more details in [Catalog]({{< ref "/docs/dev/table/catalogs" >}}#interface-in-catalog-for-supporting-time-travel).

The syntax with time travel clause is:
```sql
SELECT select_list FROM table_name FOR SYSTEM_TIME AS OF timestamp_expression
```

**Parameter Specification:**

- `FOR SYSTEM_TIME AS OF timestamp_expression`：Used to query data at a specific point in time, the `timestamp_expression` represents the historical time point you want to query. The `timestamp_expression` can be a specific timestamp or a time-related expression that can be reduced to a constant, and this expression can only apply to physical tables and not to views or sub-queries.

## Example

```sql
--use timestamp constant expression
SELECT select_list FROM paimon_tb FOR SYSTEM_TIME AS OF TIMESTAMP '2023-07-31 00:00:00'

--use expression with functions that can be reduced to a timestamp constant
SELECT select_list FROM paimon_tb FOR SYSTEM_TIME AS OF TIMESTAMP '2023-07-31 00:00:00' - INTERVAL '1' DAY
```

## Limitation

<span class="label label-danger">Attention</span> The `timestamp_expression` used in `time travel` only supports certain types of expressions that can be reduced to TIMESTAMP constants, including constant expressions of type `TIMESTAMP`, adding and subtracting operations on timestamps, as well as some partial built-in functions and UDFs.

When `UDFs` are used in a `timestamp_expression`, due to the limitations of the current framework,
some expressions cannot be directly reduced to a `TIMESTAMP` constant during SQL parsing and an exception will be thrown.

```sql
--use expression with functions that can not be reduced to a timestamp constant
SELECT select_list FROM paimon_tb FOR SYSTEM_TIME AS OF TO_TIMESTAMP_LTZ(0, 3)
```

The corresponding exceptions are as follows:

```bash
Unsupported time travel expression: TO_TIMESTAMP_LTZ(0, 3) for the expression can not be reduced to a constant by Flink.
```

## Time Zone Handling

The data type generated by the TIMESTAMP expression is TIMESTAMP type, but there's a special case in the time travel clause.
When encountering the time travel clause, the framework will convert the TIMESTAMP type to the LONG type based on the local time zone.
Therefore, the results of the same time travel query statement may vary in different time zones.
