/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.join.stream.asyncprocessing.state.JoinRecordAsyncStateView;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.utils.OuterRecord;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.util.Preconditions;

public final class JoinRecordAsyncStateViews {
    public static JoinRecordAsyncStateView create(StreamingRuntimeContext ctx, String stateName, JoinInputSideSpec inputSideSpec, InternalTypeInfo<RowData> recordType, long retentionTime) {
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(retentionTime);
        if (inputSideSpec.hasUniqueKey()) {
            if (inputSideSpec.joinKeyContainsUniqueKey()) {
                return new JoinKeyContainsUniqueKey(ctx, stateName, recordType, ttlConfig);
            }
            return new InputSideHasUniqueKey(ctx, stateName, recordType, inputSideSpec.getUniqueKeyType(), inputSideSpec.getUniqueKeySelector(), ttlConfig);
        }
        return new InputSideHasNoUniqueKey(ctx, stateName, recordType, ttlConfig);
    }

    private static final class InputSideHasNoUniqueKey
    implements JoinRecordAsyncStateView {
        private final MapState<RowData, Integer> recordState;

        private InputSideHasNoUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, StateTtlConfig ttlConfig) {
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, recordType, Types.INT);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        @Override
        public StateFuture<Void> addRecord(RowData record) {
            return this.recordState.asyncGet((Object)record).thenApply(cnt -> {
                if (cnt != null) {
                    return cnt + 1;
                }
                return 1;
            }).thenCompose(updateCnt -> this.recordState.asyncPut((Object)record, updateCnt));
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return this.recordState.asyncGet((Object)record).thenCompose(cnt -> {
                if (cnt != null) {
                    if (cnt > 1) {
                        return this.recordState.asyncPut((Object)record, (Object)(cnt - 1));
                    }
                    return this.recordState.asyncRemove((Object)record);
                }
                return StateFutureUtils.completedVoidFuture();
            });
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecords(Function<RowData, Boolean> condition) {
            ArrayList matchedRecords = new ArrayList();
            return this.recordState.asyncEntries().thenCompose(it -> it.onNext(entry -> {
                RowData record = (RowData)entry.getKey();
                int cnt = (Integer)entry.getValue();
                if (((Boolean)condition.apply(record)).booleanValue()) {
                    for (int i = 0; i < cnt; ++i) {
                        matchedRecords.add(new OuterRecord(record));
                    }
                }
            })).thenApply(VOID -> matchedRecords);
        }
    }

    private static final class InputSideHasUniqueKey
    implements JoinRecordAsyncStateView {
        private final MapState<RowData, RowData> recordState;
        private final KeySelector<RowData, RowData> uniqueKeySelector;

        private InputSideHasUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, InternalTypeInfo<RowData> uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector, StateTtlConfig ttlConfig) {
            Preconditions.checkNotNull(uniqueKeyType);
            Preconditions.checkNotNull(uniqueKeySelector);
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, uniqueKeyType, recordType);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
            this.uniqueKeySelector = uniqueKeySelector;
        }

        @Override
        public StateFuture<Void> addRecord(RowData record) {
            return StateFutureUtils.completedVoidFuture().thenCompose(VOID -> {
                RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
                return this.recordState.asyncPut((Object)uniqueKey, (Object)record);
            });
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return StateFutureUtils.completedVoidFuture().thenCompose(VOID -> {
                RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
                return this.recordState.asyncRemove((Object)uniqueKey);
            });
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecords(Function<RowData, Boolean> condition) {
            ArrayList matchedRecords = new ArrayList();
            return this.recordState.asyncValues().thenCompose(it -> it.onNext(v -> {
                if (((Boolean)condition.apply((RowData)v)).booleanValue()) {
                    matchedRecords.add(new OuterRecord((RowData)v));
                }
            })).thenApply(VOID -> matchedRecords);
        }
    }

    private static final class JoinKeyContainsUniqueKey
    implements JoinRecordAsyncStateView {
        private final ValueState<RowData> recordState;
        private final List<OuterRecord> reusedList;

        private JoinKeyContainsUniqueKey(StreamingRuntimeContext ctx, String stateName, InternalTypeInfo<RowData> recordType, StateTtlConfig ttlConfig) {
            ValueStateDescriptor recordStateDesc = new ValueStateDescriptor(stateName, recordType);
            if (ttlConfig.isEnabled()) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getValueState(recordStateDesc);
            this.reusedList = new ArrayList<OuterRecord>(1);
        }

        @Override
        public StateFuture<Void> addRecord(RowData record) {
            return this.recordState.asyncUpdate((Object)record);
        }

        @Override
        public StateFuture<Void> retractRecord(RowData record) {
            return this.recordState.asyncClear();
        }

        @Override
        public StateFuture<List<OuterRecord>> findMatchedRecords(Function<RowData, Boolean> condition) {
            return this.recordState.asyncValue().thenApply(v -> {
                this.reusedList.clear();
                if (v != null && ((Boolean)condition.apply((RowData)v)).booleanValue()) {
                    this.reusedList.add(new OuterRecord((RowData)v));
                }
                return this.reusedList;
            });
        }
    }
}

