/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream.compact;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.table.stream.AbstractStreamingWriter;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class CompactFileWriter<T>
extends AbstractStreamingWriter<T, CompactMessages.CoordinatorInput> {
    private static final long serialVersionUID = 1L;

    public CompactFileWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<T, String, ? extends StreamingFileSink.BucketsBuilder<T, String, ?>> bucketsBuilder) {
        super(bucketCheckInterval, bucketsBuilder);
    }

    @Override
    protected void partitionCreated(String partition) {
    }

    @Override
    protected void partitionInactive(String partition) {
    }

    @Override
    protected void onPartFileOpened(String partition, Path newPath) {
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.InputFile(partition, newPath)));
    }

    @Override
    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        super.commitUpToCheckpoint(checkpointId);
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.EndCheckpoint(checkpointId, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks())));
    }
}

