/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.bundle.trigger;

import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTriggerCallback;
import org.apache.flink.table.runtime.operators.bundle.trigger.CoBundleTrigger;
import org.apache.flink.util.Preconditions;

public class CountCoBundleTrigger<IN1, IN2>
implements CoBundleTrigger<IN1, IN2> {
    private final long maxCount;
    private transient BundleTriggerCallback callback;
    private transient long count = 0L;

    public CountCoBundleTrigger(long maxCount) {
        Preconditions.checkArgument((maxCount > 0L ? 1 : 0) != 0, (Object)"maxCount must be greater than 0");
        this.maxCount = maxCount;
    }

    @Override
    public void registerCallback(BundleTriggerCallback callback) {
        this.callback = (BundleTriggerCallback)Preconditions.checkNotNull((Object)callback, (String)"callback is null");
    }

    @Override
    public void onElement1(IN1 element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
            this.reset();
        }
    }

    @Override
    public void onElement2(IN2 element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public String explain() {
        return "CountCoBundleTrigger with size " + this.maxCount;
    }
}

