/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.runtime.util.EqualityAndHashcodeProvider;
import org.apache.flink.table.runtime.util.ObjectContainer;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayIntersectFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final EqualityAndHashcodeProvider equalityAndHashcodeProvider;

    public ArrayIntersectFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_INTERSECT, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType().toInternal();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.toInternal().getLogicalType());
        this.equalityAndHashcodeProvider = new EqualityAndHashcodeProvider(context, dataType);
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityAndHashcodeProvider.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData arrayOne, ArrayData arrayTwo) {
        try {
            if (arrayOne == null || arrayTwo == null) {
                return null;
            }
            HashSet<ObjectContainer> set = new HashSet<ObjectContainer>();
            for (int pos = 0; pos < arrayTwo.size(); ++pos) {
                Object element2 = this.elementGetter.getElementOrNull(arrayTwo, pos);
                ObjectContainer objectContainer = this.createObjectContainer(element2);
                set.add(objectContainer);
            }
            LinkedHashSet<ObjectContainer> res = new LinkedHashSet<ObjectContainer>();
            for (int pos = 0; pos < arrayOne.size(); ++pos) {
                Object element3 = this.elementGetter.getElementOrNull(arrayOne, pos);
                ObjectContainer objectContainer = this.createObjectContainer(element3);
                if (!set.contains(objectContainer)) continue;
                res.add(objectContainer);
            }
            return new GenericArrayData(res.stream().map(element -> element != null ? element.getObject() : null).toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    private ObjectContainer createObjectContainer(Object element) {
        if (element == null) {
            return null;
        }
        return new ObjectContainer(element, this.equalityAndHashcodeProvider::equals, this.equalityAndHashcodeProvider::hashCode);
    }

    public void close() throws Exception {
        this.equalityAndHashcodeProvider.close();
    }
}

