/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.CompressionLevel;
import flash.swf.RandomAccessBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class SwfEncoder
extends RandomAccessBuffer {
    private int bitPos = 8;
    private byte currentByte = 0;
    private int compressPos = -1;
    public int bytesWritten = 0;
    final int swfVersion;

    public SwfEncoder(int n) {
        this.swfVersion = n;
    }

    public void writeUI8(int n) {
        if (this.bitPos != 8 || n < 0 || n > 255) {
            assert (this.bitPos == 8);
            assert (n >= 0 && n <= 255) : "UI8 overflow " + Integer.toHexString(n);
        }
        super.write(n);
    }

    public void writeFixed8(float f) {
        int n = (int)(f * 256.0f) & 0xFFFF;
        this.writeUI16(n);
    }

    public void writeUI16(int n) {
        if (n == -1) {
            n = 65535;
        }
        assert (this.bitPos == 8);
        assert (n >= 0 && n <= 65535) : "UI16 overflow";
        super.write(n);
        super.write(n >> 8);
    }

    public void writeSI16(int n) {
        assert (this.bitPos == 8);
        assert (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) : "SI16 overflow";
        super.write(n);
        super.write(n >> 8);
    }

    public void write32(int n) {
        assert (this.bitPos == 8);
        super.write(n);
        super.write(n >> 8);
        super.write(n >> 16);
        super.write(n >> 24);
    }

    public void write64(long l) {
        this.write32((int)l);
        this.write32((int)(l >> 32));
    }

    public void writeFloat(float f) {
        int n = Float.floatToIntBits(f);
        this.write32(n);
    }

    public void markComp() {
        this.compressPos = this.getPos();
    }

    public void compress(CompressionLevel compressionLevel) throws IOException {
        if (this.compressPos != -1) {
            this.pos = this.compressPos;
            this.deflate(this, compressionLevel);
            this.compressPos = -1;
        }
    }

    private int deflate(OutputStream outputStream, CompressionLevel compressionLevel) throws IOException {
        int n = compressionLevel == CompressionLevel.BestSpeed ? 1 : 9;
        Deflater deflater = new Deflater(n);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
        deflaterOutputStream.write(this.buf, this.compressPos, this.count - this.compressPos);
        deflaterOutputStream.finish();
        int n2 = this.compressPos + deflater.getTotalOut();
        deflater.end();
        return n2;
    }

    public synchronized void writeTo(OutputStream outputStream, CompressionLevel compressionLevel) throws IOException {
        if (this.compressPos == -1) {
            super.writeTo(outputStream);
            this.bytesWritten = this.buf.length;
        } else {
            this.count = this.pos;
            outputStream.write(this.buf, 0, this.compressPos);
            this.bytesWritten = this.deflate(outputStream, compressionLevel);
        }
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void writeBit(boolean bl) {
        this.writeBits(bl ? 1 : 0, 1);
    }

    private void writeBits(int n, int n2) {
        while (n2 > 0) {
            if (n2 > this.bitPos) {
                this.currentByte = (byte)(this.currentByte | n << 32 - n2 >>> 32 - this.bitPos);
                super.write(this.currentByte);
                n2 -= this.bitPos;
                this.currentByte = 0;
                this.bitPos = 8;
                continue;
            }
            this.currentByte = (byte)(this.currentByte | n << 32 - n2 >>> 32 - this.bitPos);
            this.bitPos -= n2;
            n2 = 0;
            if (this.bitPos != 0) continue;
            super.write(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    public void writeUBits(int n, int n2) {
        assert (n >= 0 && n <= (1 << n2) - 1);
        this.writeBits(n, n2);
    }

    public void writeSBits(int n, int n2) {
        assert (n >= -(1 << n2 - 1) && n <= (1 << n2 - 1) - 1);
        this.writeBits(n, n2);
    }

    public void flushBits() {
        if (this.bitPos != 8) {
            super.write(this.currentByte);
            this.currentByte = 0;
            this.bitPos = 8;
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.compressPos = -1;
    }

    public void writeUI8at(int n, int n2) {
        int n3 = this.getPos();
        this.setPos(n);
        this.writeUI8(n2);
        this.setPos(n3);
    }

    public void writeUI16at(int n, int n2) {
        int n3 = this.getPos();
        this.setPos(n);
        this.writeUI16(n2);
        this.setPos(n3);
    }

    public void writeSI16at(int n, int n2) {
        int n3 = this.getPos();
        this.setPos(n);
        this.writeSI16(n2);
        this.setPos(n3);
    }

    public void write32at(int n, int n2) {
        int n3 = this.getPos();
        this.setPos(n);
        this.write32(n2);
        this.setPos(n3);
    }

    public void writeString(String string) {
        block3: {
            try {
                assert (this.bitPos == 8);
                this.write(this.swfVersion >= 6 ? string.getBytes("UTF8") : string.getBytes());
                this.write(0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void writeLengthString(String string) {
        block3: {
            try {
                assert (this.bitPos == 8);
                byte[] byArray = this.swfVersion >= 6 ? string.getBytes("UTF8") : string.getBytes();
                super.write(byArray.length + 1);
                this.write(byArray);
                this.write(0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public static int maxNum(int n, int n2, int n3, int n4) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        n4 = Math.abs(n4);
        return n > n2 ? (n > n3 ? (n > n4 ? n : n4) : (n3 > n4 ? n3 : n4)) : (n2 > n3 ? (n2 > n4 ? n2 : n4) : (n3 > n4 ? n3 : n4));
    }

    public static int minBits(int n, int n2) {
        int n3 = 1;
        int n4 = 1;
        while (n3 <= n && n2 <= 32) {
            n3 |= n4;
            ++n2;
            n4 <<= 1;
        }
        if (n2 > 32) assert (false) : "minBits " + n2 + " must not exceed 32";
        return n2;
    }

    public void writeAt(int n, byte[] byArray) {
        int n2 = this.getPos();
        this.setPos(n);
        this.write(byArray);
        this.setPos(n2);
    }
}

