/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.common.IEmbedResolver;
import org.apache.flex.compiler.common.IFileSpecificationGetter;
import org.apache.flex.compiler.common.RecursionGuard;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.parsing.as.IncludeHandler;
import org.apache.flex.compiler.internal.parsing.as.OffsetLookup;
import org.apache.flex.compiler.internal.scopes.ASFileScope;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.targets.ITargetAttributes;
import org.apache.flex.compiler.internal.targets.TargetAttributesMetadata;
import org.apache.flex.compiler.internal.tree.as.ConfigConditionBlockNode;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.ImportNode;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.scopes.IASScope;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IFileNode;
import org.apache.flex.compiler.tree.as.IFileNodeAccumulator;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.tree.as.IPackageNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.workspaces.IWorkspace;
import org.apache.flex.utils.FilenameNormalization;

public class FileNode
extends ScopedBlockNode
implements Serializable,
IFileNode,
IFileNodeAccumulator {
    private static final long serialVersionUID = 1L;
    private IFileSpecification fileSpec;
    private final IFileSpecificationGetter fileSpecGetter;
    private Collection<ICompilerProblem> problems;
    private final IncludeHandler includeHandler;
    private OffsetLookup offsetLookup;
    private final List<IImportNode> implicitImportNodes;
    private final List<IImportNode> importNodes;
    private final List<IEmbedResolver> embedNodes;
    private ITargetAttributes targetAttributes;
    private final Set<String> requiredResourceBundles;
    private final Set<FunctionNode> deferredFunctionNodes;

    private FileNode(IFileSpecificationGetter fileSpecGetter, IFileSpecification fileSpec) {
        this.fileSpecGetter = fileSpecGetter;
        this.fileSpec = fileSpec;
        this.setSourcePath(fileSpec.getPath());
        this.includeHandler = new IncludeHandler(fileSpecGetter);
        this.embedNodes = new LinkedList<IEmbedResolver>();
        this.requiredResourceBundles = new HashSet<String>();
        this.deferredFunctionNodes = new HashSet<FunctionNode>();
        this.implicitImportNodes = new LinkedList<IImportNode>();
        for (String implicitImport : ASFileScope.getImplicitImportsForAS()) {
            ImportNode implicitImportNode = ImportNode.buildImportNode(implicitImport);
            implicitImportNode.setParent(this);
            this.implicitImportNodes.add(implicitImportNode);
        }
        this.importNodes = new LinkedList<IImportNode>();
        for (IImportNode implicitImportNode : this.implicitImportNodes) {
            this.importNodes.add(implicitImportNode);
        }
    }

    public FileNode(IFileSpecificationGetter fileSpecGetter, String pathName) {
        this(fileSpecGetter, fileSpecGetter.getFileSpecification(pathName));
    }

    public FileNode(IFileSpecificationGetter fileSpecGetter) {
        this(fileSpecGetter, FilenameNormalization.normalize(""));
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.FileID;
    }

    @Override
    public IFileSpecification getFileSpecification() {
        return this.fileSpec;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.fileSpecGetter.getWorkspace();
    }

    @Override
    public void setParent(NodeBase parent) {
        super.setParent(parent);
        if (parent != null) {
            this.connectedToProjectScope();
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            assert (scope == null);
            this.initializeScope(scope);
            scope = this.getASScope();
        }
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            assert (scope != null);
            assert (scope instanceof ASFileScope);
            this.reconnectScope(scope);
        }
        super.analyze(set, scope, problems);
    }

    @Override
    public void collectImportNodes(Collection<IImportNode> importNodes) {
        super.collectImportNodes(importNodes);
        this.collectImplicitImportNodes(importNodes);
    }

    void collectImplicitImportNodes(Collection<IImportNode> importNodes) {
        importNodes.addAll(this.implicitImportNodes);
    }

    @Override
    public OffsetLookup getOffsetLookup() {
        return this.offsetLookup;
    }

    @Override
    public boolean hasIncludes() {
        return this.getFileScope().getOffsetLookup().hasIncludes();
    }

    @Override
    public long getIncludeTreeLastModified() {
        return this.getIncludeHandler().getLastModified();
    }

    @Override
    public IDefinitionNode[] getTopLevelDefinitionNodes(boolean includeDefinitionsOutsideOfPackage, boolean includeNonPublicDefinitions) {
        ArrayList<IDefinitionNode> list = new ArrayList<IDefinitionNode>();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            IASNode child = this.getChild(i);
            if (child instanceof IPackageNode) {
                IScopedNode packageBodyNode = ((IPackageNode)child).getScopedNode();
                int m = packageBodyNode.getChildCount();
                for (int j = 0; j < m; ++j) {
                    IASNode packageBodyChild = packageBodyNode.getChild(j);
                    this.addIfDefinitionNode(packageBodyChild, includeNonPublicDefinitions, list);
                }
                continue;
            }
            if (!includeDefinitionsOutsideOfPackage) continue;
            this.addIfDefinitionNode(child, includeNonPublicDefinitions, list);
        }
        return list.toArray(new IDefinitionNode[0]);
    }

    @Override
    public IDefinition[] getTopLevelDefinitions(boolean includeDefinitionsOutsideOfPackage, boolean includeNonPublicDefinitions) {
        IDefinitionNode[] nodes = this.getTopLevelDefinitionNodes(includeDefinitionsOutsideOfPackage, includeNonPublicDefinitions);
        int n = nodes.length;
        IDefinition[] definitions = new IDefinition[n];
        for (int i = 0; i < n; ++i) {
            definitions[i] = nodes[i].getDefinition();
        }
        return definitions;
    }

    @Override
    public ITargetAttributes getTargetAttributes(ICompilerProject project) {
        IClassNode classNode;
        IMetaTagNode[] metaTagSWF;
        IDefinitionNode[] definitionNodes;
        if (this.targetAttributes == null && (definitionNodes = this.getTopLevelDefinitionNodes(false, false)).length == 1 && definitionNodes[0] instanceof IClassNode && (metaTagSWF = (classNode = (IClassNode)definitionNodes[0]).getMetaTagNodesByName("SWF")) != null && metaTagSWF.length > 0) {
            if (metaTagSWF.length > 1) {
                throw new IllegalStateException("Only allow one [SWF] metadata tag.");
            }
            this.targetAttributes = new TargetAttributesMetadata(metaTagSWF[0]);
        }
        return this.targetAttributes;
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    @Override
    public void addImportNode(IImportNode node) {
        if (node.getAncestorOfType(FunctionNode.class) != null) {
            return;
        }
        this.importNodes.add(node);
    }

    @Override
    public List<IImportNode> getImportNodes() {
        return this.importNodes;
    }

    @Override
    public void addEmbedNode(IEmbedResolver node) {
        this.embedNodes.add(node);
    }

    @Override
    public List<IEmbedResolver> getEmbedNodes() {
        return this.embedNodes;
    }

    @Override
    public void addRequiredResourceBundle(String bundleName) {
        this.requiredResourceBundles.add(bundleName);
    }

    @Override
    public Set<String> getRequiredResourceBundles() {
        return this.requiredResourceBundles;
    }

    @Override
    public void addDeferredFunctionNode(FunctionNode functionNode) {
        assert (functionNode != null) : "Function node can't be null.";
        this.deferredFunctionNodes.add(functionNode);
    }

    @Override
    public synchronized void populateFunctionNodes() {
        for (FunctionNode fn : this.deferredFunctionNodes) {
            fn.parseFunctionBody(this.problems);
        }
    }

    public synchronized void parseRequiredFunctionBodies() {
        Iterator<FunctionNode> iter = this.deferredFunctionNodes.iterator();
        block3: while (iter.hasNext()) {
            FunctionNode fn = iter.next();
            if (FileNode.isInsideDisabledConfigBlock(fn)) {
                iter.remove();
                continue;
            }
            IASNode functionParent = fn.getParent();
            if (functionParent == null || functionParent instanceof FileNode) continue;
            if (functionParent instanceof ScopedBlockNode || functionParent instanceof ContainerNode) {
                functionParent = functionParent.getParent();
            }
            if (functionParent == null) continue;
            switch (functionParent.getNodeID()) {
                case ClassID: 
                case PackageID: {
                    continue block3;
                }
            }
            fn.parseFunctionBody(this.problems);
            iter.remove();
        }
    }

    private static boolean isInsideDisabledConfigBlock(FunctionNode fn) {
        ConfigConditionBlockNode configBlock = (ConfigConditionBlockNode)fn.getAncestorOfType(ConfigConditionBlockNode.class);
        return configBlock != null && configBlock.getChildCount() == 0;
    }

    public IFileSpecificationGetter getFileSpecificaitonGetter() {
        return this.fileSpecGetter;
    }

    public void setOffsetLookup(OffsetLookup offsetLookup) {
        assert (offsetLookup != null) : "OffsetLookup can't be null.";
        this.offsetLookup = offsetLookup;
    }

    public IncludeHandler getIncludeHandler() {
        return this.includeHandler;
    }

    public synchronized IASScope getTemporaryEnclosingScope(RecursionGuard scopeGuard) {
        return null;
    }

    public void processAST(EnumSet<PostProcessStep> features) {
        Collection<ICompilerProblem> problems = this.runPostProcess(features);
        if (problems != null) {
            if (this.problems == null) {
                this.problems = new ArrayList<ICompilerProblem>();
            }
            this.problems.addAll(problems);
        }
    }

    public void reconnectDefinitions(ASFileScope fileScope) {
        this.scope = fileScope;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        this.analyze(EnumSet.of(PostProcessStep.RECONNECT_DEFINITIONS), this.scope, problems);
    }

    protected void initializeScope(ASScope containingScope) {
        ASFileScope fileScope = new ASFileScope(this);
        if (this.offsetLookup != null) {
            fileScope.setOffsetLookup(this.offsetLookup);
        }
        this.scope = fileScope;
    }

    public void setProblems(Collection<ICompilerProblem> problems) {
        if (this.problems != null) {
            this.problems.addAll(problems);
        } else {
            this.problems = problems;
        }
    }

    public void addProblem(ICompilerProblem problem) {
        if (this.problems == null) {
            this.problems = new ArrayList<ICompilerProblem>();
        }
        this.problems.add(problem);
    }

    private void addIfDefinitionNode(IASNode node, boolean includeNonPublicDefinitions, List<IDefinitionNode> list) {
        String namespace;
        if (!(node instanceof IDefinitionNode)) {
            return;
        }
        IDefinitionNode definitionNode = (IDefinitionNode)node;
        if (!includeNonPublicDefinitions && !"public".equals(namespace = definitionNode.getNamespace())) {
            return;
        }
        list.add(definitionNode);
    }
}

