/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.util.Iterator;
import java.util.List;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.KeywordNode;
import org.apache.flex.compiler.internal.tree.as.PackageNode;
import org.apache.flex.compiler.internal.tree.as.parts.AccessorFunctionContentsPart;
import org.apache.flex.compiler.internal.tree.as.parts.IAccessorFunctionContentsPart;
import org.apache.flex.compiler.internal.tree.as.parts.IFunctionContentsPart;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.ICommonClassNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.IKeywordNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.as.decorators.IVariableTypeDecorator;
import org.apache.flex.compiler.tree.as.decorators.SymbolDecoratorProvider;

public abstract class AccessorNode
extends FunctionNode
implements IAccessorNode {
    public AccessorNode(IASToken functionKeyword, IASToken accessorKeyword, IdentifierNode nameNode) {
        super(functionKeyword, nameNode);
        if (accessorKeyword != null) {
            ((IAccessorFunctionContentsPart)this.contentsPart).setAccessorKeyword(new KeywordNode(accessorKeyword));
        }
    }

    public AccessorNode(IdentifierNode node, IAccessorFunctionContentsPart part) {
        super(node, part);
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.contentsPart.getFunctionKeywordNode(), fillInOffsets);
        this.addChildInOrder(((IAccessorFunctionContentsPart)this.contentsPart).getAccessorKeyword(), fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getParametersNode(), fillInOffsets);
        this.addChildInOrder(this.typeNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getContents(), fillInOffsets);
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isCastFunction() {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return super.isImplicit();
    }

    @Override
    public String getReturnType() {
        FunctionDefinition definition = this.getDefinition();
        List<IVariableTypeDecorator> list = SymbolDecoratorProvider.getProvider().getVariableTypeDecorators(definition);
        if (list.size() > 0) {
            Iterator<IVariableTypeDecorator> it = list.iterator();
            while (it.hasNext()) {
                IDefinition type = it.next().decorateVariableType(definition);
                if (!(type instanceof ITypeDefinition)) continue;
                return type.getQualifiedName();
            }
        }
        return super.getReturnType();
    }

    @Override
    protected IFunctionContentsPart createContentsPart() {
        return new AccessorFunctionContentsPart();
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        IScopedNode scopedNode = this.getScopeNode();
        IScopedNode node = scopedNode;
        if (node instanceof ICommonClassNode || node.getParent() instanceof ICommonClassNode) {
            return IVariableDefinition.VariableClassification.CLASS_MEMBER;
        }
        if (node.getParent() instanceof IInterfaceNode) {
            return IVariableDefinition.VariableClassification.INTERFACE_MEMBER;
        }
        if (node.getParent() instanceof PackageNode) {
            return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
        }
        return IVariableDefinition.VariableClassification.LOCAL;
    }

    @Override
    public IExpressionNode getAssignedValueNode() {
        return null;
    }

    @Override
    public int getDeclarationEnd() {
        return this.getEnd();
    }

    @Override
    public IKeywordNode getAccessorKeywordNode() {
        return ((IAccessorFunctionContentsPart)this.contentsPart).getAccessorKeyword();
    }
}

