/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing;

import java.io.IOException;
import java.io.Reader;
import org.apache.flex.utils.NonLockingStringReader;

public class FakingReader
extends Reader {
    protected Reader reader;
    protected NonLockingStringReader fakeReader;
    protected boolean readingFakeCharacters;

    public FakingReader(Reader reader, String fakeCharacters) {
        this.reader = reader;
        this.fakeReader = new NonLockingStringReader(fakeCharacters);
        this.readingFakeCharacters = false;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readingFakeCharacters) {
            return this.fakeReader.read(cbuf, off, len);
        }
        int charactersRead = this.reader.read(cbuf, off, len);
        if (charactersRead == -1) {
            this.readingFakeCharacters = true;
            return this.fakeReader.read(cbuf, off, len);
        }
        return charactersRead;
    }
}

