/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.mxml;

import java.util.List;
import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.codegen.mxml.IMXMLEmitter;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.projects.IASProject;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IFileNode;
import org.apache.flex.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.flex.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLBooleanNode;
import org.apache.flex.compiler.tree.mxml.IMXMLClassDefinitionNode;
import org.apache.flex.compiler.tree.mxml.IMXMLComponentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDeferredInstanceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEmbedNode;
import org.apache.flex.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFactoryNode;
import org.apache.flex.compiler.tree.mxml.IMXMLFileNode;
import org.apache.flex.compiler.tree.mxml.IMXMLImplementsNode;
import org.apache.flex.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.flex.compiler.tree.mxml.IMXMLIntNode;
import org.apache.flex.compiler.tree.mxml.IMXMLLiteralNode;
import org.apache.flex.compiler.tree.mxml.IMXMLMetadataNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNode;
import org.apache.flex.compiler.tree.mxml.IMXMLNumberNode;
import org.apache.flex.compiler.tree.mxml.IMXMLObjectNode;
import org.apache.flex.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLScriptNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStringNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import org.apache.flex.compiler.tree.mxml.IMXMLUintNode;
import org.apache.flex.compiler.tree.mxml.IMXMLVectorNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.flex.compiler.visitor.IASNodeStrategy;
import org.apache.flex.compiler.visitor.IBlockWalker;
import org.apache.flex.compiler.visitor.mxml.IMXMLBlockVisitor;
import org.apache.flex.compiler.visitor.mxml.IMXMLBlockWalker;

public class MXMLBlockWalker
implements IMXMLBlockVisitor,
IMXMLBlockWalker {
    private IASEmitter asEmitter;
    private IMXMLEmitter mxmlEmitter;
    protected List<ICompilerProblem> errors;
    protected IASProject project;
    private IASNodeStrategy mxmlStrategy;
    private IASNodeStrategy asStrategy;

    @Override
    public IASEmitter getASEmitter() {
        return this.asEmitter;
    }

    @Override
    public IMXMLEmitter getMXMLEmitter() {
        return this.mxmlEmitter;
    }

    List<ICompilerProblem> getErrors() {
        return this.errors;
    }

    public IASProject getProject() {
        return this.project;
    }

    public IASNodeStrategy getMXMLStrategy() {
        return this.mxmlStrategy;
    }

    public void setMXMLStrategy(IASNodeStrategy value) {
        this.mxmlStrategy = value;
    }

    public IASNodeStrategy getASStrategy() {
        return this.asStrategy;
    }

    public void setASStrategy(IASNodeStrategy value) {
        this.asStrategy = value;
    }

    @Override
    public void walk(IASNode node) {
        if (node instanceof IMXMLNode) {
            this.mxmlStrategy.handle(node);
        } else {
            this.asStrategy.handle(node);
        }
    }

    @Override
    public void visitCompilationUnit(ICompilationUnit unit) {
        this.debug("visitMXMLCompilationUnit()");
        IFileNode node = null;
        try {
            node = (IFileNode)((ISyntaxTreeRequestResult)unit.getSyntaxTreeRequest().get()).getAST();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.walk((IASNode)node);
    }

    public MXMLBlockWalker(List<ICompilerProblem> errors, IASProject project, IMXMLEmitter mxmlEmitter, IASEmitter asEmitter, IBlockWalker asBlockWalker) {
        this.asEmitter = asEmitter;
        this.mxmlEmitter = mxmlEmitter;
        this.project = project;
        this.errors = errors;
        asEmitter.setWalker(asBlockWalker);
        mxmlEmitter.setMXMLWalker(this);
    }

    @Override
    public void visitFile(IMXMLFileNode node) {
        this.debug("visitFile()");
        this.walk((IASNode)node.getDocumentNode());
    }

    @Override
    public void visitDeclarations(IMXMLDeclarationsNode node) {
        this.debug("visitDeclarations()");
        this.mxmlEmitter.emitDeclarations(node);
    }

    @Override
    public void visitDocument(IMXMLDocumentNode node) {
        this.debug("visitDocument()");
        IMXMLFileNode fnode = (IMXMLFileNode)node.getParent();
        this.mxmlEmitter.emitDocumentHeader(fnode);
        this.visitClassDefinition((IMXMLClassDefinitionNode)node);
        this.mxmlEmitter.emitDocumentFooter(fnode);
    }

    @Override
    public void visitClassDefinition(IMXMLClassDefinitionNode node) {
        this.debug("visitClassDefinition()");
        this.mxmlEmitter.emitClass(node);
    }

    @Override
    public void visitDeferredInstance(IMXMLDeferredInstanceNode node) {
        this.debug("visitdeferredInstance()");
        this.walk(node.getChild(0));
    }

    @Override
    public void visitEventSpecifier(IMXMLEventSpecifierNode node) {
        this.debug("visitEventSpecifier()");
        this.mxmlEmitter.emitEventSpecifier(node);
    }

    @Override
    public void visitInstance(IMXMLInstanceNode node) {
        this.debug("visitInstance()");
        this.mxmlEmitter.emitInstance(node);
    }

    @Override
    public void visitPropertySpecifier(IMXMLPropertySpecifierNode node) {
        this.debug("visitPropertySpecifier()");
        this.mxmlEmitter.emitPropertySpecifier(node);
    }

    @Override
    public void visitScript(IMXMLScriptNode node) {
        this.debug("visitScript()");
        this.mxmlEmitter.emitScript(node);
    }

    @Override
    public void visitStyleBlock(IMXMLStyleNode node) {
    }

    @Override
    public void visitStyleSpecifier(IMXMLStyleSpecifierNode node) {
        this.debug("visitStyleSpecifier()");
        this.mxmlEmitter.emitStyleSpecifier(node);
    }

    @Override
    public void visitArray(IMXMLArrayNode node) {
        this.debug("visitArray()");
        this.mxmlEmitter.emitArray(node);
    }

    @Override
    public void visitBoolean(IMXMLBooleanNode node) {
        this.debug("visitBoolean()");
        this.mxmlEmitter.emitBoolean(node);
    }

    @Override
    public void visitInt(IMXMLIntNode node) {
        this.debug("visitInt()");
        this.mxmlEmitter.emitInt(node);
    }

    @Override
    public void visitNumber(IMXMLNumberNode node) {
        this.debug("visitNumber()");
        this.mxmlEmitter.emitNumber(node);
    }

    @Override
    public void visitString(IMXMLStringNode node) {
        this.debug("visitString()");
        this.mxmlEmitter.emitString(node);
    }

    @Override
    public void visitUint(IMXMLUintNode node) {
        this.debug("visitUint()");
        this.mxmlEmitter.emitUint(node);
    }

    @Override
    public void visitLiteral(IMXMLLiteralNode node) {
        this.debug("visitLiteral()");
        this.mxmlEmitter.emitLiteral(node);
    }

    @Override
    public void visitFactory(IMXMLFactoryNode node) {
        this.debug("visitFactory()");
        this.mxmlEmitter.emitFactory(node);
    }

    @Override
    public void visitComponent(IMXMLComponentNode node) {
        this.debug("visitComponent()");
        this.mxmlEmitter.emitComponent(node);
    }

    @Override
    public void visitMetadata(IMXMLMetadataNode node) {
        this.debug("visitMetadata()");
        this.mxmlEmitter.emitMetadata(node);
    }

    @Override
    public void visitEmbed(IMXMLEmbedNode node) {
        this.debug("visitEmbed()");
        this.mxmlEmitter.emitEmbed(node);
    }

    @Override
    public void visitImplements(IMXMLImplementsNode node) {
        this.debug("visitImplements()");
        this.mxmlEmitter.emitImplements(node);
    }

    @Override
    public void visitVector(IMXMLVectorNode node) {
        this.debug("visitVector()");
        this.mxmlEmitter.emitVector(node);
    }

    @Override
    public void visitDatabinding(IMXMLDataBindingNode node) {
        this.debug("visitDatabinding()");
        this.mxmlEmitter.emitDatabinding(node);
    }

    @Override
    public void visitBinding(IMXMLBindingNode node) {
        this.debug("visitBinding()");
    }

    @Override
    public void visitObject(IMXMLObjectNode node) {
        this.debug("visitObject()");
        this.mxmlEmitter.emitObject(node);
    }

    protected void debug(String message) {
    }
}

