/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.SwcDependencyInfo;
import flex2.compiler.util.SwcExternalScriptInfo;
import flex2.compiler.util.graph.Algorithms;
import flex2.compiler.util.graph.DependencyGraph;
import flex2.compiler.util.graph.Vertex;
import flex2.compiler.util.graph.Visitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwcDependencyInfoImpl
implements SwcDependencyInfo {
    private DependencyGraph<SwcExternalScriptInfo> dependencies = new DependencyGraph();

    @Override
    public boolean dependencyExists(String swcLocation1, String swcLocation2) {
        return this.dependencies.dependencyExists(swcLocation1, swcLocation2);
    }

    @Override
    public List<String> getSwcDependencyOrder() {
        final ArrayList<String> depOrder = new ArrayList<String>(this.dependencies.size());
        Algorithms.topologicalSort(this.dependencies, new Visitor<Vertex<String, SwcExternalScriptInfo>>(){

            @Override
            public void visit(Vertex<String, SwcExternalScriptInfo> v) {
                String name = v.getWeight();
                depOrder.add(name);
            }
        });
        return depOrder;
    }

    @Override
    public Set<String> getDependencies(String swcLocation) {
        return this.dependencies.getDependencies(swcLocation);
    }

    @Override
    public SwcExternalScriptInfo getSwcExternalScriptInfo(String swcLocation) {
        return this.dependencies.get(swcLocation);
    }

    public void addSwcExternals(String swcLocation, SwcExternalScriptInfo externals) {
        if (swcLocation == null || externals == null) {
            throw new NullPointerException();
        }
        String name = swcLocation;
        this.dependencies.put(name, externals);
        if (!this.dependencies.containsVertex(name)) {
            this.dependencies.addVertex(new Vertex(name));
        }
    }

    public void addDependency(String swcLocation1, String swcLocation2) {
        if (swcLocation1 == null || swcLocation2 == null) {
            throw new NullPointerException();
        }
        String head = swcLocation1;
        String tail = swcLocation2;
        if (!head.equals(tail) && this.dependencies.containsKey(head) && this.dependencies.containsKey(tail) && !this.dependencies.dependencyExists(head, tail)) {
            this.dependencies.addDependency(head, tail);
        }
    }

    @Override
    public Set<Vertex<String, SwcExternalScriptInfo>> detectCycles() {
        return Algorithms.detectCycles(this.dependencies);
    }
}

