/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.asc.util.graph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vertex<W> {
    private static final int INITIAL_CAPACITY = 5;
    private W weight;
    int id;
    private Set<Edge> incidentEdges;
    private Set<Edge> emanatingEdges;
    private Set<Vertex<W>> predecessors;
    private List<Vertex<W>> successors;

    public Vertex(W weight) {
        this.weight = weight;
    }

    public W getWeight() {
        return this.weight;
    }

    public void addIncidentEdge(Edge e) {
        if (this.incidentEdges == null) {
            this.incidentEdges = new HashSet<Edge>(5);
        }
        this.incidentEdges.add(e);
    }

    public Set<Edge> getIncidentEdges() {
        return this.incidentEdges;
    }

    public void addEmanatingEdge(Edge e) {
        if (this.emanatingEdges == null) {
            this.emanatingEdges = new HashSet<Edge>(5);
        }
        this.emanatingEdges.add(e);
    }

    public Set<Edge> getEmanatingEdges() {
        return this.emanatingEdges;
    }

    public void addPredecessor(Vertex<W> v) {
        if (this.predecessors == null) {
            this.predecessors = new HashSet<Vertex<W>>(5);
        }
        this.predecessors.add(v);
    }

    public Set<Vertex<W>> getPredecessors() {
        return this.predecessors;
    }

    public void addSuccessor(Vertex<W> v) {
        if (this.successors == null) {
            this.successors = new ArrayList<Vertex<W>>(5);
        }
        this.successors.add(v);
    }

    public List<Vertex<W>> getSuccessors() {
        return this.successors;
    }

    public int inDegrees() {
        return this.incidentEdges == null ? 0 : this.incidentEdges.size();
    }

    public int outDegrees() {
        return this.emanatingEdges == null ? 0 : this.emanatingEdges.size();
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex) {
            return this.weight == null ? super.equals(object) : this.weight.equals(((Vertex)object).weight);
        }
        return false;
    }

    public int hashCode() {
        return this.weight != null ? this.weight.hashCode() : super.hashCode();
    }
}

