/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.ActionHandler;
import flash.swf.DebugEncoder;
import flash.swf.SwfEncoder;
import flash.swf.actions.Branch;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.GetURL;
import flash.swf.actions.GetURL2;
import flash.swf.actions.GotoFrame;
import flash.swf.actions.GotoFrame2;
import flash.swf.actions.GotoLabel;
import flash.swf.actions.Label;
import flash.swf.actions.Push;
import flash.swf.actions.SetTarget;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.Try;
import flash.swf.actions.Unknown;
import flash.swf.actions.WaitForFrame;
import flash.swf.actions.With;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.ClipActions;
import java.util.ArrayList;
import java.util.HashMap;

public class ActionEncoder
extends ActionHandler {
    private SwfEncoder writer;
    private DebugEncoder debug;
    private HashMap<Label, LabelEntry> labels;
    private ArrayList<UpdateEntry> updates;
    private int actionCount;

    public ActionEncoder(SwfEncoder writer, DebugEncoder debug) {
        this.writer = writer;
        this.debug = debug;
        this.labels = new HashMap();
        this.updates = new ArrayList();
    }

    private int getLabelOffset(Label label) {
        assert (this.labels.containsKey(label)) : "missing label";
        return this.labels.get((Object)label).offset;
    }

    private int getLabelCount(Label label) {
        assert (this.labels.containsKey(label)) : "missing label";
        return this.labels.get((Object)label).count;
    }

    public void encode(ActionList actionList) {
        block6: for (int i = 0; i < actionList.size(); ++i) {
            Action a = actionList.getAction(i);
            switch (a.code) {
                case 256: {
                    a.visit(this);
                    continue block6;
                }
                case 257: {
                    if (this.debug == null) continue block6;
                    this.debug.offset(this.writer.getPos(), (LineRecord)a);
                    continue block6;
                }
                case 258: {
                    if (this.debug == null) continue block6;
                    this.debug.registers(this.writer.getPos(), (RegisterRecord)a);
                    continue block6;
                }
                case 150: {
                    i = this.encodePush((Push)a, i, actionList);
                    ++this.actionCount;
                    continue block6;
                }
                default: {
                    if (a.code < 128) {
                        this.writer.writeUI8(a.code);
                    } else {
                        a.visit(this);
                    }
                    ++this.actionCount;
                }
            }
        }
        this.patchForwardBranches();
    }

    private void patchForwardBranches() {
        block6: for (UpdateEntry entry : this.updates) {
            switch (entry.source.code) {
                case 153: 
                case 157: {
                    int target = this.getLabelOffset(((Branch)entry.source).target);
                    this.writer.writeSI16at(entry.updatePos, target - entry.anchor);
                    continue block6;
                }
                case 148: {
                    int endWith = this.getLabelOffset(((With)entry.source).endWith);
                    this.writer.writeUI16at(entry.updatePos, endWith - entry.anchor);
                    continue block6;
                }
                case 138: 
                case 141: {
                    int skipTarget = this.getLabelCount(((WaitForFrame)entry.source).skipTarget);
                    this.writer.writeUI8at(entry.updatePos, skipTarget - entry.anchor);
                    continue block6;
                }
                case 143: {
                    Try t = (Try)entry.source;
                    int endTry = this.getLabelOffset(t.endTry);
                    this.writer.writeUI16at(entry.updatePos, endTry - entry.anchor);
                    entry.anchor = endTry;
                    if (t.hasCatch()) {
                        int endCatch = this.getLabelOffset(t.endCatch);
                        this.writer.writeUI16at(entry.updatePos + 2, endCatch - entry.anchor);
                        entry.anchor = endCatch;
                    }
                    if (!t.hasFinally()) continue block6;
                    int endFinally = this.getLabelOffset(t.endFinally);
                    this.writer.writeUI16at(entry.updatePos + 4, endFinally - entry.anchor);
                    continue block6;
                }
            }
            assert (false) : "invalid action in UpdateEntry";
        }
    }

    public void call(Action action) {
        this.writer.writeUI8(action.code);
        this.writer.writeUI16(0);
    }

    public void constantPool(ConstantPool action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI16(action.pool.length);
        for (int i = 0; i < action.pool.length; ++i) {
            this.writer.writeString(action.pool[i]);
        }
        this.updateActionHeader(updatePos);
    }

    private void updateActionHeader(int updatePos) {
        int length = this.writer.getPos() - updatePos - 2;
        if (length >= 65536) assert (false) : "action length (" + length + ") exceeds 64K";
        this.writer.writeUI16at(updatePos, length);
    }

    private int encodeActionHeader(Action action) {
        this.writer.writeUI8(action.code);
        int updatePos = this.writer.getPos();
        this.writer.writeUI16(0);
        return updatePos;
    }

    public void defineFunction(DefineFunction action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeString(action.name);
        this.writer.writeUI16(action.params.length);
        for (int i = 0; i < action.params.length; ++i) {
            this.writer.writeString(action.params[i]);
        }
        int pos = this.writer.getPos();
        this.writer.writeUI16(0);
        this.updateActionHeader(updatePos);
        new ActionEncoder(this.writer, this.debug).encode(action.actionList);
        this.writer.writeUI16at(pos, this.writer.getPos() - pos - 2);
    }

    public void defineFunction2(DefineFunction action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeString(action.name);
        this.writer.writeUI16(action.params.length);
        this.writer.writeUI8(action.regCount);
        this.writer.writeUI16(action.flags);
        for (int i = 0; i < action.params.length; ++i) {
            this.writer.writeUI8(action.paramReg[i]);
            this.writer.writeString(action.params[i]);
        }
        int pos = this.writer.getPos();
        this.writer.writeUI16(0);
        this.updateActionHeader(updatePos);
        new ActionEncoder(this.writer, this.debug).encode(action.actionList);
        this.writer.writeUI16at(pos, this.writer.getPos() - pos - 2);
    }

    public void getURL(GetURL action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeString(action.url);
        this.writer.writeString(action.target);
        this.updateActionHeader(updatePos);
    }

    public void getURL2(GetURL2 action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI8(action.method);
        this.updateActionHeader(updatePos);
    }

    public void gotoFrame(GotoFrame action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI16(action.frame);
        this.updateActionHeader(updatePos);
    }

    public void gotoFrame2(GotoFrame2 action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI8(action.playFlag);
        this.updateActionHeader(updatePos);
    }

    public void gotoLabel(GotoLabel action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeString(action.label);
        this.updateActionHeader(updatePos);
    }

    public void ifAction(Branch action) {
        this.encodeBranch(action);
    }

    public void jump(Branch action) {
        this.encodeBranch(action);
    }

    private void encodeBranch(Branch branch) {
        this.writer.writeUI8(branch.code);
        this.writer.writeUI16(2);
        int pos = this.writer.getPos();
        if (this.labels.containsKey(branch.target)) {
            this.writer.writeSI16(this.getLabelOffset(branch.target) - pos - 2);
        } else {
            this.updates.add(new UpdateEntry(pos + 2, pos, branch));
            this.writer.writeSI16(0);
        }
    }

    public void with(With action) {
        this.writer.writeUI8(action.code);
        this.writer.writeUI16(2);
        int pos = this.writer.getPos();
        this.updates.add(new UpdateEntry(pos + 2, pos, action));
        this.writer.writeUI16(0);
    }

    public void waitForFrame(WaitForFrame action) {
        this.writer.writeUI8(action.code);
        this.writer.writeUI16(3);
        this.writer.writeUI16(action.frame);
        int pos = this.writer.getPos();
        this.updates.add(new UpdateEntry(this.actionCount + 1, pos, action));
        this.writer.writeUI8(0);
    }

    public void waitForFrame2(WaitForFrame action) {
        this.writer.writeUI8(action.code);
        this.writer.writeUI16(1);
        int pos = this.writer.getPos();
        this.updates.add(new UpdateEntry(this.actionCount + 1, pos, action));
        this.writer.writeUI8(0);
    }

    public void label(Label label) {
        assert (!this.labels.containsKey(label)) : "found duplicate label";
        int labelPos = this.writer.getPos();
        this.labels.put(label, new LabelEntry(labelPos, this.actionCount));
    }

    public int encodePush(Push push, int j, ActionList actions) {
        int updatePos = this.encodeActionHeader(push);
        do {
            Object value = push.value;
            int type = Push.getTypeCode(value);
            this.writer.writeUI8(type);
            switch (type) {
                case 0: {
                    this.writer.writeString(value.toString());
                    break;
                }
                case 1: {
                    int bits = Float.floatToIntBits(((Float)value).floatValue());
                    this.writer.write32(bits);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.writer.writeUI8(((Byte)value).intValue() & 0xFF);
                    break;
                }
                case 5: {
                    this.writer.writeUI8((Boolean)value != false ? 1 : 0);
                    break;
                }
                case 6: {
                    double d = (Double)value;
                    long num = Double.doubleToLongBits(d);
                    this.writer.write32((int)(num >> 32));
                    this.writer.write32((int)num);
                    break;
                }
                case 7: {
                    this.writer.write32((Integer)value);
                    break;
                }
                case 8: {
                    this.writer.writeUI8(((Short)value).intValue());
                    break;
                }
                case 9: {
                    this.writer.writeUI16(((Short)value).intValue() & 0xFFFF);
                }
            }
            if (this.debug == null) {
                while (j + 1 < actions.size() && actions.getAction((int)(j + 1)).code == 257) {
                    ++j;
                }
            }
            if (++j < actions.size()) {
                Action a = actions.getAction(j);
                if (a.code == 150) {
                    push = (Push)a;
                    continue;
                }
            }
            push = null;
        } while (push != null);
        this.updateActionHeader(updatePos);
        return j - 1;
    }

    public void setTarget(SetTarget action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeString(action.targetName);
        this.updateActionHeader(updatePos);
    }

    public void storeRegister(StoreRegister action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI8(action.register);
        this.updateActionHeader(updatePos);
    }

    public void strictMode(StrictMode action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.writeUI8(action.mode ? 1 : 0);
        this.updateActionHeader(updatePos);
    }

    public void tryAction(Try a) {
        int updatePos = this.encodeActionHeader(a);
        this.writer.writeUI8(a.flags);
        int trySizePos = this.writer.getPos();
        this.writer.writeUI16(0);
        this.writer.writeUI16(0);
        this.writer.writeUI16(0);
        if (a.hasRegister()) {
            this.writer.writeUI8(a.catchReg);
        } else {
            this.writer.writeString(a.catchName);
        }
        this.updateActionHeader(updatePos);
        int tryStart = this.writer.getPos();
        this.updates.add(new UpdateEntry(tryStart, trySizePos, a));
    }

    public void unknown(Unknown action) {
        int updatePos = this.encodeActionHeader(action);
        this.writer.write(action.data);
        this.updateActionHeader(updatePos);
    }

    public void encodeClipActions(ClipActions clipActions) {
        this.writer.writeUI16(0);
        this.encodeClipEventFlags(clipActions.allEventFlags, this.writer);
        for (ClipActionRecord r : clipActions.clipActionRecords) {
            this.encodeClipActionRecord(r);
        }
        if (this.writer.swfVersion >= 6) {
            this.writer.write32(0);
        } else {
            this.writer.writeUI16(0);
        }
    }

    private void encodeClipActionRecord(ClipActionRecord r) {
        this.encodeClipEventFlags(r.eventFlags, this.writer);
        int pos = this.writer.getPos();
        this.writer.write32(0);
        if ((r.eventFlags & 0x20000) != 0) {
            this.writer.writeUI8(r.keyCode);
        }
        this.encode(r.actionList);
        this.writer.write32at(pos, this.writer.getPos() - pos - 4);
    }

    private void encodeClipEventFlags(int flags, SwfEncoder w) {
        if (w.swfVersion >= 6) {
            w.write32(flags);
        } else {
            w.writeUI16(flags);
        }
    }

    private static class LabelEntry {
        int offset;
        int count;

        public LabelEntry(int offset, int count) {
            this.count = count;
            this.offset = offset;
        }
    }

    private static class UpdateEntry {
        int anchor;
        int updatePos;
        Action source;

        public UpdateEntry(int anchor, int updatePos, Action source) {
            this.anchor = anchor;
            this.updatePos = updatePos;
            this.source = source;
        }
    }
}

