////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package flashx.textLayout.events
{
    
    /**
     *  Constants for the values of the <code>direction</code> property
     *  of a ScrollEvent.
     *
     *  @see flashx.textLayout.events.ScrollEvent
     * 
     * @playerversion Flash 10.0
     * @playerversion AIR 2.0
     * @langversion 3.0
     */
    public final class ScrollEventDirection
    {
        //--------------------------------------------------------------------------
        //
        //  Class constants
        //
        //--------------------------------------------------------------------------
        
        /**
         *  The user scrolled horizontally.
         * 
         * @playerversion Flash 10.0
         * @playerversion AIR 2.0
         * @langversion 3.0
         */
        public static const HORIZONTAL:String = "horizontal";
        
        /**
         *  The user scrolled vertically.
         * 
         * @playerversion Flash 10.0
         * @playerversion AIR 2.0
         * @langversion 3.0
         */
        public static const VERTICAL:String = "vertical";
    }
    
}
