/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Handler;
import adobe.abc.Name;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method
implements Comparable<Method> {
    GlobalOptimizer.InputAbc abc;
    public final int id;
    int emit_id;
    public Edge entry;
    Typeref[] params;
    public Object[] values;
    int optional_count;
    Typeref returns;
    Name name;
    String debugName;
    Name[] paramNames;
    int flags;
    Type cx;
    private int blockId;
    private int exprId;
    int edgeId;
    String kind;
    int max_stack;
    int local_count;
    int max_scope;
    int code_len;
    Typeref activation;
    public Handler[] handlers = OptimizerConstants.nohandlers;
    Map<Expr, Typeref> verifier_types = null;
    Map<Expr, Integer> fixedLocals = new HashMap<Expr, Integer>();

    Method(int id, GlobalOptimizer.InputAbc abc) {
        this.id = id;
        this.abc = abc;
    }

    public boolean needsRest() {
        return (this.flags & 4) != 0;
    }

    public boolean needsArguments() {
        return (this.flags & 1) != 0;
    }

    public boolean hasParamNames() {
        return (this.flags & 0x80) != 0;
    }

    public boolean hasOptional() {
        return (this.flags & 8) != 0;
    }

    public boolean isNative() {
        return (this.flags & 0x20) != 0;
    }

    public int nameIndex(Name n) {
        return this.abc.nameIndex(n);
    }

    public Name getName(int idx) {
        return this.abc.names[idx];
    }

    public int stringIndex(Object s) {
        return Arrays.asList(this.abc.strings).indexOf(s);
    }

    public String getString(int idx) {
        return this.abc.strings[idx];
    }

    public int typeIndex(Type t) {
        return Arrays.asList(this.abc.classes).indexOf(t);
    }

    public Type getType(int idx) {
        return this.abc.classes[idx];
    }

    public int methodIndex(Method m) {
        return Arrays.asList(this.abc.methods).indexOf(m);
    }

    public Method getMethod(int idx) {
        return this.abc.methods[idx];
    }

    @Override
    public int compareTo(Method m) {
        return this.id - m.id;
    }

    public String toString() {
        return this.kind + " " + String.valueOf(this.getName());
    }

    public Name getParameterName(int idx) {
        if (this.paramNames != null) {
            return this.paramNames[idx];
        }
        if (0 == idx) {
            return new Name("this");
        }
        return new Name("arg" + idx);
    }

    public Name getName() {
        return this.name;
    }

    public Typeref[] getParams() {
        return this.params;
    }

    public Typeref getReturnType() {
        return this.returns;
    }

    public Algorithms.Deque<Block> depthFirstCfg() {
        return Algorithms.dfs(this.entry.to);
    }

    public int getNextBlockId() {
        return this.blockId++;
    }

    public int getNextExprId() {
        return this.exprId++;
    }

    public List<Name> getAllNames() {
        return Arrays.asList(this.abc.names);
    }
}

