/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMappings {
    private Map<String, Map<String, String>> namespaceMap = new HashMap<String, Map<String, String>>();
    private Map<String, Set<String>> lookupOnly = new HashMap<String, Set<String>>();

    public NameMappings copy() {
        NameMappings m = new NameMappings();
        for (String uri : this.namespaceMap.keySet()) {
            Map<String, String> classMap = this.namespaceMap.get(uri);
            m.namespaceMap.put(uri, new HashMap<String, String>(classMap));
        }
        m.lookupOnly.putAll(this.lookupOnly);
        return m;
    }

    public String lookupPackageName(String nsURI, String localPart) {
        String className = this.lookupClassName(nsURI, localPart);
        if (className == null) {
            return null;
        }
        int index = className.indexOf(":");
        return index == -1 ? "" : className.substring(0, index);
    }

    public String lookupClassName(String nsURI, String localPart) {
        Map<String, String> classMap = this.namespaceMap.get(nsURI);
        return classMap == null ? null : classMap.get(localPart);
    }

    public String resolveClassName(String namespaceURI, String localPart) {
        String className = this.lookupClassName(namespaceURI, localPart);
        if (className == null) {
            if ("*".equals(namespaceURI)) {
                className = localPart;
            } else if (namespaceURI.length() > 2 && namespaceURI.endsWith(".*")) {
                className = namespaceURI.substring(0, namespaceURI.length() - 2) + ':' + localPart;
                className = className.intern();
            }
        }
        return className;
    }

    public Map<String, String> getNamespace(String nsURI) {
        return this.namespaceMap.get(nsURI);
    }

    public Set<String> getNamespaces() {
        return this.namespaceMap.keySet();
    }

    public void addMappings(NameMappings other) {
        for (Map.Entry<String, Map<String, String>> e : other.namespaceMap.entrySet()) {
            String namespaceURI = e.getKey();
            Map<String, String> mappings = e.getValue();
            for (Map.Entry<String, String> lc : mappings.entrySet()) {
                String local = lc.getKey();
                String className = lc.getValue();
                this.addClass(namespaceURI, local, className);
            }
        }
    }

    public boolean addClass(String namespaceURI, String localPart, String className) {
        Map<Object, Object> classMap = null;
        if (this.namespaceMap.containsKey(namespaceURI)) {
            classMap = this.namespaceMap.get(namespaceURI);
        } else {
            classMap = new HashMap();
            this.namespaceMap.put(namespaceURI.intern(), classMap);
        }
        String current = (String)classMap.get(localPart);
        if (current == null) {
            classMap.put(localPart.intern(), className.intern());
        } else if (!current.equals(className)) {
            return false;
        }
        return true;
    }

    public void addLookupOnly(String namespaceURI, String cls) {
        Set<String> classes = this.lookupOnly.get(namespaceURI);
        if (classes == null) {
            classes = new HashSet<String>();
            this.lookupOnly.put(namespaceURI, classes);
        }
        classes.add(cls);
    }

    public boolean isLookupOnly(String namespaceURI, String cls) {
        boolean result = false;
        Set<String> classes = this.lookupOnly.get(namespaceURI);
        if (classes != null) {
            result = classes.contains(cls);
        }
        return result;
    }
}

