/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;

public class ConfigurationPathResolver
implements SinglePathResolver {
    private String root;

    public void setRoot(String root) {
        this.root = root;
    }

    public VirtualFile resolve(String path) {
        LocalFile resolved = null;
        File absoluteOrRelativeFile = FileUtil.openFile(path);
        if (absoluteOrRelativeFile != null && FileUtils.exists((File)absoluteOrRelativeFile) && FileUtils.isAbsolute((File)absoluteOrRelativeFile)) {
            resolved = new LocalFile(absoluteOrRelativeFile);
        } else if (this.root != null) {
            String rootRelativePath = this.root + File.separator + path;
            File rootRelativeFile = FileUtil.openFile(rootRelativePath);
            if (rootRelativeFile != null && FileUtils.exists((File)rootRelativeFile)) {
                resolved = new LocalFile(rootRelativeFile);
            }
        } else if ((absoluteOrRelativeFile = FileUtils.getAbsoluteFile((File)absoluteOrRelativeFile)) != null && FileUtils.exists((File)absoluteOrRelativeFile)) {
            resolved = new LocalFile(absoluteOrRelativeFile);
        }
        if (resolved != null && Trace.pathResolver) {
            Trace.trace((String)("ConfigurationPathResolver.resolve: resolved " + path + " to " + resolved.getName()));
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualFile getVirtualFile(String file, ConfigurationPathResolver configResolver, ConfigurationValue cfgval) throws ConfigurationException {
        VirtualFile vFile;
        String cfgContext;
        ConfigurationPathResolver relative = null;
        String string = cfgContext = cfgval != null ? cfgval.getContext() : null;
        if (cfgContext != null) {
            relative = new ConfigurationPathResolver();
            relative.setRoot(cfgContext);
        }
        if ((vFile = ThreadLocalToolkit.getPathResolver().resolve(relative, file)) == null) {
            String oldRoot = null;
            boolean rootChanged = false;
            try {
                if (cfgContext != null) {
                    oldRoot = configResolver.root;
                    rootChanged = true;
                    configResolver.setRoot(cfgContext);
                }
                vFile = configResolver.resolve(file);
            }
            finally {
                if (rootChanged) {
                    configResolver.setRoot(oldRoot);
                }
            }
        }
        if (vFile == null) {
            if (cfgval == null) {
                throw new ConfigurationException.CannotOpen(file, null, null, -1);
            }
            throw new ConfigurationException.CannotOpen(file, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        return vFile;
    }
}

