/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LoggingSettings;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.ServicesConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientConfiguration
implements ServicesConfiguration {
    protected final Map channelSettings = new HashMap();
    protected final List defaultChannels = new ArrayList(4);
    protected final List serviceSettings;
    protected LoggingSettings loggingSettings;
    protected Map configPaths;
    protected final Map clusterSettings = new HashMap();
    protected FlexClientSettings flexClientSettings;

    public ClientConfiguration() {
        this.serviceSettings = new ArrayList();
        this.configPaths = new HashMap();
    }

    @Override
    public void addChannelSettings(String id, ChannelSettings settings) {
        this.channelSettings.put(id, settings);
    }

    @Override
    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    @Override
    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    @Override
    public void addDefaultChannel(String id) {
        this.defaultChannels.add(id);
    }

    @Override
    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    @Override
    public void addServiceSettings(ServiceSettings settings) {
        this.serviceSettings.add(settings);
    }

    @Override
    public ServiceSettings getServiceSettings(String serviceType) {
        for (ServiceSettings serviceSettings : this.serviceSettings) {
            if (!serviceSettings.getId().equals(serviceType)) continue;
            return serviceSettings;
        }
        return null;
    }

    @Override
    public List getAllServiceSettings() {
        return this.serviceSettings;
    }

    public void addClusterSettings(ClusterSettings settings) {
        if (settings.isDefault()) {
            for (ClusterSettings cs : this.clusterSettings.values()) {
                if (!cs.isDefault()) continue;
                ConfigurationException cx = new ConfigurationException();
                cx.setMessage(10214, new Object[]{settings.getClusterName(), cs.getClusterName()});
                throw cx;
            }
        }
        if (this.clusterSettings.containsKey(settings.getClusterName())) {
            ConfigurationException cx = new ConfigurationException();
            cx.setMessage(10206, new Object[]{settings.getClusterName()});
            throw cx;
        }
        this.clusterSettings.put(settings.getClusterName(), settings);
    }

    @Override
    public ClusterSettings getClusterSettings(String clusterId) {
        for (ClusterSettings cs : this.clusterSettings.values()) {
            if (cs.getClusterName() == null && clusterId == null) {
                return cs;
            }
            if (cs.getClusterName() == null || !cs.getClusterName().equals(clusterId)) continue;
            return cs;
        }
        return null;
    }

    @Override
    public ClusterSettings getDefaultCluster() {
        for (ClusterSettings cs : this.clusterSettings.values()) {
            if (!cs.isDefault()) continue;
            return cs;
        }
        return null;
    }

    @Override
    public void setLoggingSettings(LoggingSettings settings) {
        this.loggingSettings = settings;
    }

    @Override
    public LoggingSettings getLoggingSettings() {
        return this.loggingSettings;
    }

    public void addConfigPath(String path, long modified) {
        this.configPaths.put(path, new Long(modified));
    }

    public Map getConfigPaths() {
        return this.configPaths;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }
}

