/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.infrastructure.bulkimport.constants;

public final class ClientPersonConstants {

    private ClientPersonConstants() {

    }

    public static final int FIRST_NAME_COL = 0;// A
    public static final int LAST_NAME_COL = 1;// B
    public static final int MIDDLE_NAME_COL = 2;// C
    public static final int OFFICE_NAME_COL = 3;// D
    public static final int STAFF_NAME_COL = 4;// E
    public static final int EXTERNAL_ID_COL = 5;// F
    public static final int ACTIVE_COL = 6;// G
    public static final int ACTIVATION_DATE_COL = 7;// H
    public static final int SUBMITTED_ON_COL = 8; // I
    public static final int MOBILE_NO_COL = 9;// J
    public static final int DOB_COL = 10;// K
    public static final int CLIENT_TYPE_COL = 11;// L
    public static final int GENDER_COL = 12;// M
    public static final int CLIENT_CLASSIFICATION_COL = 13;// N
    public static final int IS_STAFF_COL = 14;// O
    public static final int ADDRESS_ENABLED_COL = 15;// P
    public static final int ADDRESS_TYPE_COL = 16;// Q
    public static final int STREET_COL = 17;// R
    public static final int ADDRESS_LINE_1_COL = 18;// S
    public static final int ADDRESS_LINE_2_COL = 19;// T
    public static final int ADDRESS_LINE_3_COL = 20;// U
    public static final int CITY_COL = 21;// V
    public static final int STATE_PROVINCE_COL = 22;// W
    public static final int COUNTRY_COL = 23;// X
    public static final int POSTAL_CODE_COL = 24;// Y
    public static final int IS_ACTIVE_ADDRESS_COL = 25;// Z
    public static final int WARNING_COL = 26;// AA
    public static final int STATUS_COL = 27;// AB
    public static final int RELATIONAL_OFFICE_NAME_COL = 35;// AJ
    public static final int RELATIONAL_OFFICE_OPENING_DATE_COL = 36;// AK
    public static final int LOOKUP_GENDER_COL = 37;// AL
    public static final int LOOKUP_CLIENT_CLASSIFICATION_COL = 38;// AM
    public static final int LOOKUP_CLIENT_TYPES_COL = 39;// AN
    public static final int LOOKUP_ADDRESS_TYPE_COL = 40;// AO
    public static final int LOOKUP_STATE_PROVINCE_COL = 41;// AP
    public static final int LOOKUP_COUNTRY_COL = 42;// AQ
}
