/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.AnnotationReader;
import aQute.bnd.component.ComponentDef;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.TagResource;
import aQute.libg.header.OSGiHeader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DSAnnotations
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Map<String, Map<String, String>> header = OSGiHeader.parseHeader(analyzer.getProperty("-dsannotations"));
        if (header.size() == 0) {
            return false;
        }
        Set<Instruction> instructions = Instruction.replaceWithInstruction(header).keySet();
        HashSet<Clazz> list = new HashSet<Clazz>(analyzer.getClassspace().values());
        String sc = analyzer.getProperty("Service-Component");
        ArrayList<String> names = new ArrayList<String>();
        if (sc != null && sc.trim().length() > 0) {
            names.add(sc);
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            for (Instruction instruction : instructions) {
                Clazz c = (Clazz)i.next();
                System.out.println("fqn " + c.getFQN() + " " + instruction);
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated()) {
                    i.remove();
                    continue;
                }
                ComponentDef definition = AnnotationReader.getDefinition(c, analyzer);
                if (definition == null) continue;
                definition.prepare(analyzer);
                String name = "OSGI-INF/" + definition.name + ".xml";
                names.add(name);
                analyzer.getJar().putResource(name, new TagResource(definition.getTag()));
            }
        }
        sc = Processor.append(names.toArray(new String[names.size()]));
        analyzer.setProperty("Service-Component", sc);
        return false;
    }
}

