/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Installer
implements BundleActivator {
    private List m_artifacts;
    private MavenProject m_project;
    private boolean m_deployCurrent;
    private List m_bundles;

    public Installer(List artifacts, List bundles, MavenProject project, boolean deployCurrentArtifact) {
        this.m_artifacts = artifacts;
        this.m_project = project;
        this.m_deployCurrent = deployCurrentArtifact;
        this.m_bundles = bundles;
    }

    private void installIPOJO(BundleContext context) throws BundleException {
        String path = this.getUrlByArtifactId("org.apache.felix.ipojo").toString();
        Bundle bundle = context.installBundle(path);
        bundle.start();
    }

    private void installJunit(BundleContext context) throws BundleException {
        String path = this.getUrlByArtifactId("org.apache.felix.ipojo.junit4osgi").toString();
        Bundle bundle = context.installBundle(path);
        bundle.start();
    }

    private void installExtender(BundleContext context) throws BundleException {
        String path = this.getUrlByArtifactId("org.apache.felix.ipojo.handler.extender").toString();
        Bundle bundle = context.installBundle(path);
        bundle.start();
    }

    private void deployBundles(BundleContext context) throws BundleException {
        for (int i = 0; i < this.m_bundles.size(); ++i) {
            URL url = (URL)this.m_bundles.get(i);
            Bundle bundle = context.installBundle(url.toString());
            bundle.start();
        }
    }

    private URL getUrlByArtifactId(String id) {
        for (int i = 0; i < this.m_artifacts.size(); ++i) {
            Artifact artifact = (Artifact)this.m_artifacts.get(i);
            if (!artifact.getArtifactId().equals(id)) continue;
            try {
                return artifact.getFile().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void deployProjectArtifact(BundleContext context) throws BundleException {
        if (!this.m_deployCurrent) {
            return;
        }
        File file = this.m_project.getArtifact().getFile();
        try {
            if (file.exists()) {
                if (file.getName().endsWith("jar")) {
                    JarFile jar = new JarFile(file);
                    if (jar.getManifest().getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
                        Bundle bundle = context.installBundle(file.toURL().toString());
                        bundle.start();
                    } else {
                        System.err.println("The current artifact " + file.getName() + " is not a valid bundle");
                    }
                } else {
                    System.err.println("The current artifact " + file.getName() + " is not a Jar file.");
                }
            } else {
                System.err.println("The current artifact " + file.getName() + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new BundleException("The current project artifact cannot be installed (" + e.getMessage() + ")");
        }
    }

    public void start(BundleContext context) {
        try {
            this.installIPOJO(context);
            this.installExtender(context);
            this.installJunit(context);
            this.deployBundles(context);
            this.deployProjectArtifact(context);
        }
        catch (BundleException e) {
            System.err.println("Cannot start the framework : " + e.getMessage());
            return;
        }
    }

    public void stop(BundleContext context) {
    }
}

