/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.datafactory.fluent.models.PrivateEndpointConnectionResourceInner;
import com.azure.resourcemanager.datafactory.implementation.PrivateEndpointConnectionResourceImpl;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionOperations;
import com.azure.resourcemanager.datafactory.models.PrivateEndpointConnectionResource;

public final class PrivateEndpointConnectionOperationsImpl
implements PrivateEndpointConnectionOperations {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionOperationsImpl.class);
    private final PrivateEndpointConnectionOperationsClient innerClient;
    private final DataFactoryManager serviceManager;

    public PrivateEndpointConnectionOperationsImpl(PrivateEndpointConnectionOperationsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateEndpointConnectionResource> getWithResponse(String resourceGroupName, String factoryName, String privateEndpointConnectionName, String ifNoneMatch, Context context) {
        Response<PrivateEndpointConnectionResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, ifNoneMatch, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateEndpointConnectionResourceImpl((PrivateEndpointConnectionResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateEndpointConnectionResource get(String resourceGroupName, String factoryName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionResourceInner inner = this.serviceClient().get(resourceGroupName, factoryName, privateEndpointConnectionName);
        if (inner != null) {
            return new PrivateEndpointConnectionResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String privateEndpointConnectionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, context);
    }

    @Override
    public void delete(String resourceGroupName, String factoryName, String privateEndpointConnectionName) {
        this.serviceClient().delete(resourceGroupName, factoryName, privateEndpointConnectionName);
    }

    @Override
    public PrivateEndpointConnectionResource getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        String localIfNoneMatch = null;
        return (PrivateEndpointConnectionResource)this.getWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, localIfNoneMatch, Context.NONE).getValue();
    }

    @Override
    public Response<PrivateEndpointConnectionResource> getByIdWithResponse(String id, String ifNoneMatch, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, ifNoneMatch, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String factoryName = Utils.getValueFromIdByName(id, "factories");
        if (factoryName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'factories'.", id)));
        }
        String privateEndpointConnectionName = Utils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, factoryName, privateEndpointConnectionName, context);
    }

    private PrivateEndpointConnectionOperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionResourceImpl define(String name) {
        return new PrivateEndpointConnectionResourceImpl(name, this.manager());
    }
}

