/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientImpl;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

public final class ClientBuilder
implements Cloneable {
    private final Set<URI> endpoints = new HashSet<URI>();
    private ByteSequence user;
    private ByteSequence password;
    private ExecutorService executorService;
    private String loadBalancerPolicy;
    private SslContext sslContext;
    private String authority;
    private Integer maxInboundMessageSize;
    private Map<Metadata.Key<?>, Object> headers;
    private Map<Metadata.Key<?>, Object> authHeaders;
    private List<ClientInterceptor> interceptors;
    private List<ClientInterceptor> authInterceptors;
    private ByteSequence namespace = ByteSequence.EMPTY;
    private long retryDelay = 500L;
    private long retryMaxDelay = 2500L;
    private ChronoUnit retryChronoUnit = ChronoUnit.MILLIS;
    private Duration keepaliveTime = Duration.ofSeconds(30L);
    private Duration keepaliveTimeout = Duration.ofSeconds(10L);
    private Boolean keepaliveWithoutCalls = true;
    private Duration retryMaxDuration;
    private Duration connectTimeout;
    private boolean discovery;
    private boolean waitForReady = true;

    ClientBuilder() {
    }

    public Collection<URI> endpoints() {
        return Collections.unmodifiableCollection(this.endpoints);
    }

    public ClientBuilder endpoints(Collection<URI> endpoints) {
        Preconditions.checkNotNull(endpoints, (Object)"endpoints can't be null");
        for (URI endpoint : endpoints) {
            Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint can't be null");
            Preconditions.checkArgument((endpoint.toString().trim().length() > 0 ? 1 : 0) != 0, (Object)("invalid endpoint: endpoint=" + endpoint));
            this.endpoints.add(endpoint);
        }
        return this;
    }

    public ClientBuilder endpoints(URI ... endpoints) {
        Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints can't be null");
        return this.endpoints(Arrays.asList(endpoints));
    }

    public ClientBuilder endpoints(String ... endpoints) {
        return this.endpoints(Util.toURIs(Arrays.asList(endpoints)));
    }

    public ByteSequence user() {
        return this.user;
    }

    public ClientBuilder user(ByteSequence user) {
        Preconditions.checkNotNull((Object)user, (Object)"user can't be null");
        this.user = user;
        return this;
    }

    public ByteSequence password() {
        return this.password;
    }

    public ClientBuilder password(ByteSequence password) {
        Preconditions.checkNotNull((Object)password, (Object)"password can't be null");
        this.password = password;
        return this;
    }

    public ByteSequence namespace() {
        return this.namespace;
    }

    public ClientBuilder namespace(ByteSequence namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace can't be null");
        this.namespace = namespace;
        return this;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        Preconditions.checkNotNull((Object)executorService, (Object)"executorService can't be null");
        this.executorService = executorService;
        return this;
    }

    public ClientBuilder loadBalancerPolicy(String loadBalancerPolicy) {
        Preconditions.checkNotNull((Object)loadBalancerPolicy, (Object)"loadBalancerPolicy can't be null");
        this.loadBalancerPolicy = loadBalancerPolicy;
        return this;
    }

    public String loadBalancerPolicy() {
        return this.loadBalancerPolicy;
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public ClientBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ClientBuilder sslContext(Consumer<SslContextBuilder> consumer) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        consumer.accept(builder);
        return this.sslContext(builder.build());
    }

    public String authority() {
        return this.authority;
    }

    public ClientBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public Integer maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public ClientBuilder maxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
        return this;
    }

    public Map<Metadata.Key<?>, Object> headers() {
        return this.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.headers);
    }

    public ClientBuilder headers(Map<Metadata.Key<?>, Object> headers) {
        this.headers = new HashMap(headers);
        return this;
    }

    public ClientBuilder header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public Map<Metadata.Key<?>, Object> authHeaders() {
        return this.authHeaders == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.authHeaders);
    }

    public ClientBuilder authHeaders(Map<Metadata.Key<?>, Object> authHeaders) {
        this.authHeaders = new HashMap(authHeaders);
        return this;
    }

    public ClientBuilder authHeader(String key, String value) {
        if (this.authHeaders == null) {
            this.authHeaders = new HashMap();
        }
        this.authHeaders.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), value);
        return this;
    }

    public List<ClientInterceptor> interceptors() {
        return this.interceptors;
    }

    public ClientBuilder interceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = new ArrayList<ClientInterceptor>(interceptors);
        return this;
    }

    public ClientBuilder interceptor(ClientInterceptor interceptor, ClientInterceptor ... interceptors) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientInterceptor>();
        }
        this.interceptors.add(interceptor);
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public List<ClientInterceptor> authInterceptors() {
        return this.authInterceptors;
    }

    public ClientBuilder authInterceptors(List<ClientInterceptor> interceptors) {
        this.authInterceptors = new ArrayList<ClientInterceptor>(interceptors);
        return this;
    }

    public ClientBuilder authInterceptors(ClientInterceptor interceptor, ClientInterceptor ... interceptors) {
        if (this.authInterceptors == null) {
            this.authInterceptors = new ArrayList<ClientInterceptor>();
        }
        this.authInterceptors.add(interceptor);
        this.authInterceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public long retryDelay() {
        return this.retryDelay;
    }

    public ClientBuilder retryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public long retryMaxDelay() {
        return this.retryMaxDelay;
    }

    public ClientBuilder retryMaxDelay(long retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
        return this;
    }

    public Duration keepaliveTime() {
        return this.keepaliveTime;
    }

    public ClientBuilder keepaliveTime(Duration keepaliveTime) {
        this.keepaliveTime = keepaliveTime;
        return this;
    }

    public Duration keepaliveTimeout() {
        return this.keepaliveTimeout;
    }

    public ClientBuilder keepaliveTimeout(Duration keepaliveTimeout) {
        this.keepaliveTimeout = keepaliveTimeout;
        return this;
    }

    public Boolean keepaliveWithoutCalls() {
        return this.keepaliveWithoutCalls;
    }

    public ClientBuilder keepaliveWithoutCalls(Boolean keepaliveWithoutCalls) {
        this.keepaliveWithoutCalls = keepaliveWithoutCalls;
        return this;
    }

    public ChronoUnit retryChronoUnit() {
        return this.retryChronoUnit;
    }

    public ClientBuilder retryChronoUnit(ChronoUnit retryChronoUnit) {
        this.retryChronoUnit = retryChronoUnit;
        return this;
    }

    public Duration retryMaxDuration() {
        return this.retryMaxDuration;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public ClientBuilder retryMaxDuration(Duration retryMaxDuration) {
        this.retryMaxDuration = retryMaxDuration;
        return this;
    }

    public ClientBuilder connectTimeout(Duration connectTimeout) {
        long millis;
        if (connectTimeout != null && (long)((int)(millis = connectTimeout.toMillis())) != millis) {
            throw new IllegalArgumentException("connectTimeout outside of its bounds, max value: 2147483647");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean discovery() {
        return this.discovery;
    }

    public ClientBuilder discovery(boolean discovery) {
        this.discovery = discovery;
        return this;
    }

    public boolean waitForReady() {
        return this.waitForReady;
    }

    public ClientBuilder waitForReady(boolean waitForReady) {
        this.waitForReady = waitForReady;
        return this;
    }

    public Client build() {
        Preconditions.checkState((!this.endpoints.isEmpty() ? 1 : 0) != 0, (Object)"please configure etcd server endpoints before build.");
        return new ClientImpl(this);
    }

    public ClientBuilder copy() {
        try {
            return (ClientBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EtcdExceptionFactory.toEtcdException((Throwable)e);
        }
    }
}

