/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class Pipeline {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="activities")
    private List<Activity> activities;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, ParameterSpecification> parameters;
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, VariableSpecification> variables;
    @JsonProperty(value="concurrency")
    private Integer concurrency;
    @JsonProperty(value="annotations")
    private List<Object> annotations;
    @JsonProperty(value="runDimensions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Object> runDimensions;
    @JsonProperty(value="folder")
    private PipelineFolder folder;
    @JsonProperty(value="policy")
    private PipelinePolicy policy;

    public String description() {
        return this.description;
    }

    public Pipeline withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public Pipeline withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public Map<String, ParameterSpecification> parameters() {
        return this.parameters;
    }

    public Pipeline withParameters(Map<String, ParameterSpecification> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, VariableSpecification> variables() {
        return this.variables;
    }

    public Pipeline withVariables(Map<String, VariableSpecification> variables) {
        this.variables = variables;
        return this;
    }

    public Integer concurrency() {
        return this.concurrency;
    }

    public Pipeline withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public List<Object> annotations() {
        return this.annotations;
    }

    public Pipeline withAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Map<String, Object> runDimensions() {
        return this.runDimensions;
    }

    public Pipeline withRunDimensions(Map<String, Object> runDimensions) {
        this.runDimensions = runDimensions;
        return this;
    }

    public PipelineFolder folder() {
        return this.folder;
    }

    public Pipeline withFolder(PipelineFolder folder) {
        this.folder = folder;
        return this;
    }

    public PipelinePolicy policy() {
        return this.policy;
    }

    public Pipeline withPolicy(PipelinePolicy policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.activities() != null) {
            this.activities().forEach(e -> e.validate());
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.variables() != null) {
            this.variables().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }
}

