/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.msi.fluent.ManagedServiceIdentityClient;
import com.azure.resourcemanager.msi.implementation.IdentitesImpl;
import com.azure.resourcemanager.msi.implementation.ManagedServiceIdentityClientBuilder;
import com.azure.resourcemanager.msi.models.Identities;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import java.util.Objects;

public final class MsiManager
extends Manager<ManagedServiceIdentityClient> {
    private final AuthorizationManager authorizationManager;
    private Identities identities;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static MsiManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new MsiManager(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    public static MsiManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new MsiManager(httpPipeline, profile);
    }

    private MsiManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new ManagedServiceIdentityClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.authorizationManager = AuthorizationManager.authenticate((HttpPipeline)httpPipeline, (AzureProfile)profile);
    }

    public Identities identities() {
        if (this.identities == null) {
            this.identities = new IdentitesImpl(((ManagedServiceIdentityClient)this.serviceClient()).getUserAssignedIdentities(), this);
        }
        return this.identities;
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public MsiManager authenticate(TokenCredential credential, AzureProfile profile) {
            return MsiManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public MsiManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

