/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.share.models.Range;
import java.util.Locale;

public final class ShareFileRange {
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileRange.class);
    private static final String RANGE_HEADER_FORMAT = "bytes=%d-%d";
    private static final String BEGIN_RANGE_HEADER_FORMAT = "bytes=%d-";
    private final long start;
    private final Long end;

    public ShareFileRange(long start) {
        this(start, null);
    }

    public ShareFileRange(long start, Long end) {
        if (start < 0L) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("ShareFileRange offset must be greater than or equal to 0."));
        }
        this.start = start;
        if (end != null && end < 0L) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(new IllegalArgumentException("ShareFileRange end must be greater than or equal to 0 if specified.")));
        }
        this.end = end;
    }

    public ShareFileRange(Range range) {
        this.start = range.getStart();
        this.end = range.getEnd();
    }

    public long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public String toString() {
        if (this.end != null) {
            return String.format(Locale.ROOT, RANGE_HEADER_FORMAT, this.start, this.end);
        }
        return String.format(Locale.ROOT, BEGIN_RANGE_HEADER_FORMAT, this.start);
    }

    public String toHeaderValue() {
        if (this.start == 0L && this.end == null) {
            return null;
        }
        return this.toString();
    }
}

