/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.dolphinscheduler.api.configuration.TaskTypeConfiguration;
import org.apache.dolphinscheduler.api.dto.FavTaskDto;
import org.apache.dolphinscheduler.api.service.FavTaskService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.dao.entity.FavTask;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.FavTaskMapper;
import org.springframework.stereotype.Service;

@Service
public class FavTaskServiceImpl
extends BaseServiceImpl
implements FavTaskService {
    @Resource
    private TaskTypeConfiguration taskTypeConfiguration;
    @Resource
    private FavTaskMapper favMapper;

    @Override
    public List<FavTaskDto> getFavTaskList(User loginUser) {
        Set userFavTaskTypes = this.favMapper.getUserFavTaskTypes(loginUser.getId().intValue());
        List<FavTaskDto> defaultTaskTypes = this.taskTypeConfiguration.getDefaultTaskTypes();
        ArrayList<FavTaskDto> result = new ArrayList<FavTaskDto>();
        defaultTaskTypes.forEach(e -> {
            try {
                FavTaskDto clone = (FavTaskDto)e.clone();
                if (userFavTaskTypes.contains(clone.getTaskType())) {
                    clone.setCollection(true);
                }
                result.add(clone);
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        });
        return result;
    }

    @Override
    public boolean deleteFavTask(User loginUser, String taskType) {
        return this.favMapper.deleteUserFavTask(loginUser.getId().intValue(), taskType);
    }

    @Override
    public int addFavTask(User loginUser, String taskType) {
        this.favMapper.deleteUserFavTask(loginUser.getId().intValue(), taskType);
        return this.favMapper.insert((Object)new FavTask(null, taskType, loginUser.getId().intValue()));
    }
}

