/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConnectionStateListener
implements ConnectionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerConnectionStateListener.class);
    private final RegistryClient registryClient;

    public WorkerConnectionStateListener(RegistryClient registryClient) {
        this.registryClient = registryClient;
    }

    public void onUpdate(ConnectionState state) {
        log.info("Worker received a {} event from registry, the current server state is {}", (Object)state, (Object)ServerLifeCycleManager.getServerStatus());
        switch (state) {
            case CONNECTED: {
                break;
            }
            case SUSPENDED: {
                break;
            }
            case RECONNECTED: {
                log.warn("Worker reconnect to registry");
                break;
            }
            case DISCONNECTED: {
                this.registryClient.getStoppable().stop("Worker disconnected from registry, will stop myself");
            }
        }
    }
}

