/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.ObjectMetaMixIn;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.zjsonpatch.JsonDiff;
import java.util.Map;
import java.util.function.BiFunction;

public class PatchUtils {
    private PatchUtils() {
    }

    public static String withoutRuntimeState(Object object, Format format, boolean omitStatus) {
        return PatchUtils.withoutRuntimeState(object, format, omitStatus, (m, v) -> {
            try {
                return m.writeValueAsString(v);
            }
            catch (JsonProcessingException e) {
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        });
    }

    static JsonNode withoutRuntimeState(Object object, boolean omitStatus) {
        return PatchUtils.withoutRuntimeState(object, Format.JSON, omitStatus, (m, v) -> (JsonNode)m.convertValue(v, JsonNode.class));
    }

    static <T> T withoutRuntimeState(Object object, Format format, boolean omitStatus, BiFunction<ObjectMapper, Object, T> result) {
        ObjectMapper mapper = SingletonHolder.patchMapper;
        if (format == Format.YAML) {
            mapper = SingletonHolder.yamlMapper;
        }
        Object value = object;
        if (omitStatus) {
            Map raw = (Map)mapper.convertValue(object, Map.class);
            raw.remove("status");
            value = raw;
        }
        return result.apply(mapper, value);
    }

    public static String jsonDiff(Object current, Object updated, boolean omitStatus) {
        try {
            return SingletonHolder.patchMapper.writeValueAsString((Object)JsonDiff.asJson((JsonNode)PatchUtils.withoutRuntimeState(current, omitStatus), (JsonNode)PatchUtils.withoutRuntimeState(updated, omitStatus)));
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private static class SingletonHolder {
        public static final ObjectMapper patchMapper = Serialization.jsonMapper().copy();
        public static final ObjectMapper yamlMapper;

        private SingletonHolder() {
        }

        static {
            patchMapper.addMixIn(ObjectMeta.class, ObjectMetaMixIn.class);
            patchMapper.setConfig(patchMapper.getSerializationConfig().without(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS));
            yamlMapper = Serialization.yamlMapper().copy();
            yamlMapper.addMixIn(ObjectMeta.class, ObjectMetaMixIn.class);
            yamlMapper.setConfig(yamlMapper.getSerializationConfig().without(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS));
        }
    }

    public static enum Format {
        YAML,
        JSON;

    }
}

