/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.time.DurationUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperConnectionStateListener;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperTreeCacheListenerAdapter;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZookeeperRegistry
implements Registry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistry.class);
    private final ZookeeperRegistryProperties.ZookeeperProperties properties;
    private final CuratorFramework client;
    private final Map<String, TreeCache> treeCacheMap = new ConcurrentHashMap<String, TreeCache>();
    private static final ThreadLocal<Map<String, InterProcessMutex>> threadLocalLockMap = new ThreadLocal();

    ZookeeperRegistry(ZookeeperRegistryProperties registryProperties) {
        this.properties = registryProperties.getZookeeper();
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry((int)this.properties.getRetryPolicy().getBaseSleepTime().toMillis(), this.properties.getRetryPolicy().getMaxRetries(), (int)this.properties.getRetryPolicy().getMaxSleep().toMillis());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.properties.getConnectString()).retryPolicy((RetryPolicy)retryPolicy).namespace(this.properties.getNamespace()).sessionTimeoutMs(DurationUtils.toMillisInt((Duration)this.properties.getSessionTimeout())).connectionTimeoutMs(DurationUtils.toMillisInt((Duration)this.properties.getConnectionTimeout()));
        String digest = this.properties.getDigest();
        if (!Strings.isNullOrEmpty((String)digest)) {
            builder.authorization("digest", digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
    }

    public void start() {
        StopWatch stopWatch = StopWatch.createStarted();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(DurationUtils.toMillisInt((Duration)this.properties.getBlockUntilConnected()), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new RegistryException("zookeeper connect failed to: " + this.properties.getConnectString() + " in : " + this.properties.getBlockUntilConnected().toMillis() + "ms");
            }
            stopWatch.stop();
            log.info("ZookeeperRegistry started at: {}/ms", (Object)stopWatch.getTime());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("Zookeeper registry start failed", (Throwable)e);
        }
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.client.getConnectionStateListenable().addListener((Object)new ZookeeperConnectionStateListener(listener));
    }

    public void connectUntilTimeout(@NonNull Duration timeout) throws RegistryException {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            if (!this.client.blockUntilConnected(DurationUtils.toMillisInt((Duration)timeout), TimeUnit.MILLISECONDS)) {
                throw new RegistryException(String.format("Cannot connect to registry in %s s", timeout.getSeconds()));
            }
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException(String.format("Cannot connect to registry in %s s", timeout.getSeconds()), (Throwable)e);
        }
    }

    public void subscribe(String path, SubscribeListener listener) {
        TreeCache treeCache = this.treeCacheMap.computeIfAbsent(path, $ -> new TreeCache(this.client, path));
        treeCache.getListenable().addListener((Object)new ZookeeperTreeCacheListenerAdapter(path, listener));
        try {
            treeCache.start();
        }
        catch (Exception e) {
            this.treeCacheMap.remove(path);
            throw new RegistryException("Failed to subscribe listener for key: " + path, (Throwable)e);
        }
    }

    public String get(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get data error", (Throwable)e);
        }
    }

    public boolean exists(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper check key is existed error", (Throwable)e);
        }
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        CreateMode mode = deleteOnDisconnect ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RegistryException("Failed to put registry key: " + key, (Throwable)e);
        }
    }

    public List<String> children(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get children error", (Throwable)e);
        }
    }

    public void delete(String nodePath) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(nodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RegistryException("Failed to delete registry key: " + nodePath, (Throwable)e);
        }
    }

    public boolean acquireLock(String key) {
        Map<String, InterProcessMutex> processMutexMap = threadLocalLockMap.get();
        if (null == processMutexMap) {
            processMutexMap = new HashMap<String, InterProcessMutex>();
            threadLocalLockMap.set(processMutexMap);
        }
        InterProcessMutex interProcessMutex = null;
        try {
            interProcessMutex = Optional.ofNullable(processMutexMap.get(key)).orElse(new InterProcessMutex(this.client, key));
            if (interProcessMutex.isAcquiredInThisProcess()) {
                return true;
            }
            interProcessMutex.acquire();
            processMutexMap.put(key, interProcessMutex);
            return true;
        }
        catch (Exception e) {
            try {
                if (interProcessMutex != null) {
                    interProcessMutex.release();
                }
                throw new RegistryException(String.format("zookeeper get lock: %s error", key), (Throwable)e);
            }
            catch (Exception exception) {
                throw new RegistryException(String.format("zookeeper get lock: %s error", key), (Throwable)e);
            }
        }
    }

    public boolean acquireLock(String key, long timeout) {
        Map<String, InterProcessMutex> processMutexMap = threadLocalLockMap.get();
        if (null == processMutexMap) {
            processMutexMap = new HashMap<String, InterProcessMutex>();
            threadLocalLockMap.set(processMutexMap);
        }
        InterProcessMutex interProcessMutex = null;
        try {
            interProcessMutex = Optional.ofNullable(processMutexMap.get(key)).orElse(new InterProcessMutex(this.client, key));
            if (interProcessMutex.isAcquiredInThisProcess()) {
                return true;
            }
            if (interProcessMutex.acquire(timeout, TimeUnit.MILLISECONDS)) {
                processMutexMap.put(key, interProcessMutex);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            try {
                if (interProcessMutex != null) {
                    interProcessMutex.release();
                }
                throw new RegistryException(String.format("zookeeper get lock: %s error", key), (Throwable)e);
            }
            catch (Exception exception) {
                throw new RegistryException(String.format("zookeeper get lock: %s error", key), (Throwable)e);
            }
        }
    }

    public boolean releaseLock(String key) {
        Map<String, InterProcessMutex> processMutexMap = threadLocalLockMap.get();
        if (processMutexMap == null) {
            return true;
        }
        InterProcessMutex interProcessMutex = processMutexMap.get(key);
        if (null == interProcessMutex) {
            return false;
        }
        try {
            interProcessMutex.release();
            processMutexMap.remove(key);
            if (processMutexMap.isEmpty()) {
                threadLocalLockMap.remove();
            }
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper release lock error", (Throwable)e);
        }
        return true;
    }

    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    public void close() {
        this.treeCacheMap.values().forEach(CloseableUtils::closeQuietly);
        CloseableUtils.closeQuietly((Closeable)this.client);
    }
}

