/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstanceRelation;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceMapDao;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerRequest;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SubWorkflowParameters;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow.SubWorkflowControlClient;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow.SubWorkflowLogicTaskRuntimeContext;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow.SubWorkflowTracker;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.events.AbstractTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SubWorkflowLogicTask
extends AbstractLogicTask<SubWorkflowParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubWorkflowLogicTask.class);
    private SubWorkflowLogicTaskRuntimeContext subWorkflowLogicTaskRuntimeContext;
    private final IWorkflowExecutionRunnable workflowExecutionRunnable;
    private final ApplicationContext applicationContext;
    private SubWorkflowTracker subWorkflowTracker;
    private ITaskExecutor taskExecutor;

    public SubWorkflowLogicTask(TaskExecutionContext taskExecutionContext, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutor taskExecutor, ApplicationContext applicationContext) {
        super(taskExecutionContext);
        this.taskExecutor = taskExecutor;
        this.workflowExecutionRunnable = workflowExecutionRunnable;
        this.applicationContext = applicationContext;
        this.subWorkflowLogicTaskRuntimeContext = (SubWorkflowLogicTaskRuntimeContext)JSONUtils.parseObject((String)taskExecutionContext.getAppIds(), SubWorkflowLogicTaskRuntimeContext.class);
        this.onTaskRunning();
    }

    @Override
    public void start() throws MasterTaskExecuteException {
        this.subWorkflowLogicTaskRuntimeContext = this.initializeSubWorkflowInstance();
        this.upsertSubWorkflowRelation();
        this.taskExecutionContext.setAppIds(JSONUtils.toJsonString((Object)this.subWorkflowLogicTaskRuntimeContext));
        this.taskExecutor.getTaskExecutorEventBus().publish((AbstractTaskExecutorLifecycleEvent)TaskExecutorRuntimeContextChangedLifecycleEvent.of((ITaskExecutor)this.taskExecutor));
        this.subWorkflowTracker = new SubWorkflowTracker(this.subWorkflowLogicTaskRuntimeContext, (WorkflowInstanceDao)this.applicationContext.getBean(WorkflowInstanceDao.class));
    }

    @Override
    public TaskExecutionStatus getTaskExecutionState() {
        if (this.subWorkflowTracker == null) {
            return this.taskExecutionStatus;
        }
        this.taskExecutionStatus = this.subWorkflowTracker.getSubWorkflowState();
        return this.taskExecutionStatus;
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        if (this.subWorkflowLogicTaskRuntimeContext == null) {
            log.info("subWorkflowLogicTaskRuntimeContext is null cannot pause");
            return;
        }
        Integer subWorkflowInstanceId = this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId();
        WorkflowInstancePauseResponse pauseResponse = ((SubWorkflowControlClient)this.applicationContext.getBean(SubWorkflowControlClient.class)).pauseWorkflowInstance(new WorkflowInstancePauseRequest(subWorkflowInstanceId));
        if (pauseResponse.isSuccess()) {
            log.info("Pause sub workflowInstance: id={}", (Object)(subWorkflowInstanceId + " success"));
        } else {
            log.info("Pause sub workflowInstance: id={} failed with response: {}", (Object)subWorkflowInstanceId, (Object)pauseResponse);
        }
    }

    @Override
    public void kill() throws MasterTaskExecuteException {
        if (this.subWorkflowLogicTaskRuntimeContext == null) {
            log.info("subWorkflowLogicTaskRuntimeContext is null cannot kill");
            return;
        }
        Integer subWorkflowInstanceId = this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId();
        WorkflowInstanceStopResponse stopResponse = ((SubWorkflowControlClient)this.applicationContext.getBean(SubWorkflowControlClient.class)).stopWorkflowInstance(new WorkflowInstanceStopRequest(subWorkflowInstanceId));
        if (stopResponse.isSuccess()) {
            log.info("Kill sub workflowInstance: id={}", (Object)(subWorkflowInstanceId + " success"));
        } else {
            log.info("Kill sub workflowInstance: id={} failed with response: {}", (Object)subWorkflowInstanceId, (Object)stopResponse);
        }
    }

    @Override
    public ITaskParameterDeserializer<SubWorkflowParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (SubWorkflowParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<SubWorkflowParameters>(){});
    }

    private SubWorkflowLogicTaskRuntimeContext initializeSubWorkflowInstance() {
        if (this.subWorkflowLogicTaskRuntimeContext == null) {
            return this.triggerNewSubWorkflow();
        }
        switch (this.workflowExecutionRunnable.getWorkflowExecuteContext().getCommand().getCommandType()) {
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                return this.recoverFromFaultTolerantTasks();
            }
            case RECOVER_SUSPENDED_PROCESS: {
                return this.recoverFromSuspendTasks();
            }
            case START_FAILURE_TASK_PROCESS: {
                return this.recoverFromFailedTasks();
            }
        }
        return this.triggerNewSubWorkflow();
    }

    private SubWorkflowLogicTaskRuntimeContext recoverFromFaultTolerantTasks() {
        WorkflowInstanceDao workflowInstanceDao = (WorkflowInstanceDao)this.applicationContext.getBean(WorkflowInstanceDao.class);
        WorkflowInstance subWorkflowInstance = (WorkflowInstance)workflowInstanceDao.queryById((Serializable)this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId());
        if (subWorkflowInstance != null) {
            return this.subWorkflowLogicTaskRuntimeContext;
        }
        return this.triggerNewSubWorkflow();
    }

    private SubWorkflowLogicTaskRuntimeContext recoverFromFailedTasks() {
        SubWorkflowControlClient subWorkflowControlClient = (SubWorkflowControlClient)this.applicationContext.getBean(SubWorkflowControlClient.class);
        if (this.subWorkflowLogicTaskRuntimeContext == null) {
            log.info("The task: {} triggerType is FAILED_RECOVER but runtimeContext is null will trigger again", (Object)this.taskExecutionContext.getTaskName());
            return this.triggerNewSubWorkflow();
        }
        WorkflowInstanceRecoverFailureTasksRequest recoverFailureTasksRequest = WorkflowInstanceRecoverFailureTasksRequest.builder().workflowInstanceId(this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId()).userId(Integer.valueOf(this.taskExecutionContext.getExecutorId())).build();
        subWorkflowControlClient.triggerFromFailureTasks(recoverFailureTasksRequest);
        return this.subWorkflowLogicTaskRuntimeContext;
    }

    private SubWorkflowLogicTaskRuntimeContext recoverFromSuspendTasks() {
        SubWorkflowControlClient subWorkflowControlClient = (SubWorkflowControlClient)this.applicationContext.getBean(SubWorkflowControlClient.class);
        if (this.subWorkflowLogicTaskRuntimeContext == null) {
            log.info("The task: {} is recover from suspend but runtimeContext is null will trigger again", (Object)this.taskExecutionContext.getTaskName());
            return this.triggerNewSubWorkflow();
        }
        WorkflowInstanceRecoverSuspendTasksRequest recoverSuspendTasksRequest = WorkflowInstanceRecoverSuspendTasksRequest.builder().workflowInstanceId(this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId()).userId(Integer.valueOf(this.taskExecutionContext.getExecutorId())).build();
        subWorkflowControlClient.triggerFromSuspendTasks(recoverSuspendTasksRequest);
        return this.subWorkflowLogicTaskRuntimeContext;
    }

    private SubWorkflowLogicTaskRuntimeContext triggerNewSubWorkflow() {
        WorkflowInstance workflowInstance = this.workflowExecutionRunnable.getWorkflowInstance();
        WorkflowDefinition subWorkflowDefinition = (WorkflowDefinition)((WorkflowDefinitionDao)this.applicationContext.getBean(WorkflowDefinitionDao.class)).queryByCode(((SubWorkflowParameters)this.taskParameters).getWorkflowDefinitionCode()).orElseThrow(() -> new IllegalArgumentException("Cannot find the sub workflow definition: " + ((SubWorkflowParameters)this.taskParameters).getWorkflowDefinitionCode()));
        ICommandParam commandParam = (ICommandParam)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), ICommandParam.class);
        WorkflowManualTriggerRequest workflowManualTriggerRequest = WorkflowManualTriggerRequest.builder().userId(Integer.valueOf(this.taskExecutionContext.getExecutorId())).workflowDefinitionCode(Long.valueOf(subWorkflowDefinition.getCode())).workflowDefinitionVersion(Integer.valueOf(subWorkflowDefinition.getVersion())).failureStrategy(workflowInstance.getFailureStrategy()).warningType(workflowInstance.getWarningType()).warningGroupId(workflowInstance.getWarningGroupId()).workflowInstancePriority(workflowInstance.getWorkflowInstancePriority()).workerGroup(workflowInstance.getWorkerGroup()).tenantCode(workflowInstance.getTenantCode()).environmentCode(workflowInstance.getEnvironmentCode()).startParamList(commandParam.getCommandParams()).dryRun(Flag.of((int)workflowInstance.getDryRun())).build();
        Integer subWorkflowInstanceId = ((SubWorkflowControlClient)this.applicationContext.getBean(SubWorkflowControlClient.class)).triggerSubWorkflow(workflowManualTriggerRequest);
        return SubWorkflowLogicTaskRuntimeContext.of(subWorkflowInstanceId);
    }

    private void upsertSubWorkflowRelation() {
        WorkflowInstanceMapDao workflowInstanceMapDao = (WorkflowInstanceMapDao)this.applicationContext.getBean(WorkflowInstanceMapDao.class);
        WorkflowInstanceRelation workflowInstanceRelation = workflowInstanceMapDao.queryWorkflowMapByParent(Integer.valueOf(this.taskExecutionContext.getWorkflowInstanceId()), Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        if (workflowInstanceRelation == null) {
            workflowInstanceRelation = WorkflowInstanceRelation.builder().parentWorkflowInstanceId(this.taskExecutionContext.getWorkflowInstanceId()).parentTaskInstanceId(this.taskExecutionContext.getTaskInstanceId()).workflowInstanceId(this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId().intValue()).build();
            workflowInstanceMapDao.insert((Object)workflowInstanceRelation);
        } else {
            workflowInstanceRelation.setWorkflowInstanceId(this.subWorkflowLogicTaskRuntimeContext.getSubWorkflowInstanceId().intValue());
            workflowInstanceMapDao.updateById((Object)workflowInstanceRelation);
        }
    }
}

