/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutorRepository;

public class TaskExecutorRepository
implements ITaskExecutorRepository {
    private final Map<Integer, ITaskExecutor> taskExecutorMap = new ConcurrentHashMap<Integer, ITaskExecutor>();

    @Override
    public void put(ITaskExecutor taskExecutor) {
        Preconditions.checkNotNull((Object)taskExecutor);
        this.taskExecutorMap.put(taskExecutor.getId(), taskExecutor);
    }

    @Override
    public Optional<ITaskExecutor> get(Integer taskExecutorId) {
        return Optional.ofNullable(this.taskExecutorMap.get(taskExecutorId));
    }

    @Override
    public Collection<ITaskExecutor> getAll() {
        return this.taskExecutorMap.values();
    }

    @Override
    public boolean contains(Integer taskExecutorId) {
        return this.taskExecutorMap.containsKey(taskExecutorId);
    }

    @Override
    public void remove(Integer taskExecutorId) {
        this.taskExecutorMap.remove(taskExecutorId);
    }

    @Override
    public void clear() {
        this.taskExecutorMap.clear();
    }
}

