/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.codec.api.MessageEncoderException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.util.Strings;

public class LdapEncoder {
    private LdapApiService codec;

    public LdapEncoder(LdapApiService codec) {
        if (codec == null) {
            throw new NullPointerException("codec argument cannot be null");
        }
        this.codec = codec;
    }

    private int computeControlLength(Control control) {
        int controlValueLength = ((CodecControl)control).computeLength();
        int oidLengh = Strings.getBytesUtf8((String)control.getOid()).length;
        int controlLength = 1 + TLV.getNbBytes((int)oidLengh) + oidLengh;
        if (control.isCritical()) {
            controlLength += 3;
        }
        if (controlValueLength != 0) {
            controlLength += 1 + TLV.getNbBytes((int)controlValueLength) + controlValueLength;
        }
        return controlLength;
    }

    private ByteBuffer encodeControl(ByteBuffer buffer, Control control) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            int controlLength = this.computeControlLength(control);
            buffer.put(TLV.getBytes((int)controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        BerValue.encode((ByteBuffer)buffer, (byte[])Strings.getBytesUtf8((String)control.getOid()));
        if (control.isCritical()) {
            BerValue.encode((ByteBuffer)buffer, (boolean)control.isCritical());
        }
        return buffer;
    }

    public ByteBuffer encodeMessage(Message message) throws EncoderException {
        MessageDecorator<Message> decorator = MessageDecorator.getDecorator(this.codec, message);
        int length = this.computeMessageLength(decorator);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        try {
            try {
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)decorator.getMessageLength()));
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
            }
            BerValue.encode((ByteBuffer)buffer, (int)message.getMessageId());
            decorator.encode(buffer);
            Map<String, Control> controls = decorator.getControls();
            if (controls != null && controls.size() > 0) {
                buffer.put((byte)-96);
                buffer.put(TLV.getBytes((int)decorator.getControlsLength()));
                for (Control control : controls.values()) {
                    this.encodeControl(buffer, control);
                    int controlValueLength = ((CodecControl)control).computeLength();
                    if (controlValueLength <= 0) continue;
                    buffer.put(UniversalTag.OCTET_STRING.getValue());
                    buffer.put(TLV.getBytes((int)controlValueLength));
                    ((CodecControl)control).encode(buffer);
                }
            }
        }
        catch (EncoderException ee) {
            throw new MessageEncoderException(message.getMessageId(), ee.getMessage(), (Exception)((Object)ee));
        }
        buffer.flip();
        return buffer;
    }

    private int computeMessageLength(MessageDecorator<? extends Message> messageDecorator) {
        int ldapMessageLength = 2 + BerValue.getNbBytes((int)messageDecorator.getDecorated().getMessageId());
        ldapMessageLength += messageDecorator.computeLength();
        Map<String, Control> controls = messageDecorator.getControls();
        if (controls.size() > 0) {
            int controlsSequenceLength = 0;
            for (Control control : controls.values()) {
                int controlLength = this.computeControlLength(control);
                controlsSequenceLength += 1 + TLV.getNbBytes((int)controlLength) + controlLength;
            }
            messageDecorator.setControlsLength(controlsSequenceLength);
            ldapMessageLength += 1 + TLV.getNbBytes((int)controlsSequenceLength) + controlsSequenceLength;
        }
        messageDecorator.setMessageLength(ldapMessageLength);
        return 1 + ldapMessageLength + TLV.getNbBytes((int)ldapMessageLength);
    }

    public static void encodeReferral(ByteBuffer buffer, Referral referral) throws EncoderException {
        Collection ldapUrlsBytes = referral.getLdapUrlsBytes();
        if (ldapUrlsBytes != null && !ldapUrlsBytes.isEmpty()) {
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes((int)referral.getReferralLength()));
            for (byte[] ldapUrlBytes : ldapUrlsBytes) {
                BerValue.encode((ByteBuffer)buffer, (byte[])ldapUrlBytes);
            }
        }
    }

    public static int computeReferralLength(Referral referral) {
        if (referral != null) {
            Collection ldapUrls = referral.getLdapUrls();
            if (ldapUrls != null && !ldapUrls.isEmpty()) {
                int referralLength = 0;
                for (String ldapUrl : ldapUrls) {
                    byte[] ldapUrlBytes = Strings.getBytesUtf8((String)ldapUrl);
                    referralLength += 1 + TLV.getNbBytes((int)ldapUrlBytes.length) + ldapUrlBytes.length;
                    referral.addLdapUrlBytes(ldapUrlBytes);
                }
                referral.setReferralLength(referralLength);
                return referralLength;
            }
            return 0;
        }
        return 0;
    }
}

