/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.api.util.Strings;

public final class LdapSyntaxDescriptionSyntaxChecker
extends SyntaxChecker {
    private transient LdapSyntaxDescriptionSchemaParser schemaParser = new LdapSyntaxDescriptionSchemaParser();
    public static final LdapSyntaxDescriptionSyntaxChecker INSTANCE = new LdapSyntaxDescriptionSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.54");

    private LdapSyntaxDescriptionSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        try {
            this.schemaParser.parseLdapSyntaxDescription(strValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<LdapSyntaxDescriptionSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.54");
        }

        @Override
        public LdapSyntaxDescriptionSyntaxChecker build() {
            return new LdapSyntaxDescriptionSyntaxChecker(this.oid);
        }
    }
}

