/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttributeTypeRegistry
extends DefaultSchemaObjectRegistry<AttributeType>
implements AttributeTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttributeTypeRegistry.class);
    private Map<String, OidNormalizer> oidNormalizerMap = new HashMap<String, OidNormalizer>();
    private Map<String, Set<AttributeType>> oidToDescendantSet = new HashMap<String, Set<AttributeType>>();

    public DefaultAttributeTypeRegistry() {
        super(SchemaObjectType.ATTRIBUTE_TYPE, new OidRegistry());
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() {
        return Collections.unmodifiableMap(this.oidNormalizerMap);
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws LdapException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
            return descendants != null && !descendants.isEmpty();
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public boolean hasDescendants(AttributeType ancestor) throws LdapException {
        String oid = ancestor.getOid();
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        return descendants != null && !descendants.isEmpty();
    }

    @Override
    public Iterator<AttributeType> descendants(String ancestorId) throws LdapException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
            if (descendants == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return descendants.iterator();
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public Iterator<AttributeType> descendants(AttributeType ancestor) throws LdapException {
        String oid = ancestor.getOid();
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return descendants.iterator();
    }

    @Override
    public void registerDescendants(AttributeType attributeType, AttributeType ancestor) throws LdapException {
        if (ancestor == null) {
            return;
        }
        Set<AttributeType> descendants = this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants == null) {
            descendants = new HashSet<AttributeType>(1);
            this.oidToDescendantSet.put(ancestor.getOid(), descendants);
        }
        descendants.add(attributeType);
    }

    @Override
    public void unregisterDescendants(AttributeType attributeType, AttributeType ancestor) throws LdapException {
        if (ancestor == null) {
            return;
        }
        Set<AttributeType> descendants = this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants != null) {
            descendants.remove(attributeType);
            if (descendants.isEmpty()) {
                this.oidToDescendantSet.remove(ancestor.getOid());
            }
        }
    }

    @Override
    public AttributeType unregister(String numericOid) throws LdapException {
        try {
            AttributeType removed = (AttributeType)((Object)super.unregister(numericOid));
            this.removeMappingFor(removed);
            this.oidToDescendantSet.remove(numericOid);
            this.unregisterDescendants(removed, removed.getSuperior());
            return removed;
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public void addMappingFor(AttributeType attributeType) throws LdapException {
        OidNormalizer oidNormalizer;
        MatchingRule equality = attributeType.getEquality();
        String oid = attributeType.getOid();
        if (equality == null) {
            LOG.debug("Attribute {} does not have an EQUALITY MatchingRule : using NoopNormalizer", (Object)attributeType.getName());
            oidNormalizer = new OidNormalizer(oid, new NoOpNormalizer(attributeType.getOid()));
        } else {
            oidNormalizer = new OidNormalizer(oid, equality.getNormalizer());
        }
        this.oidNormalizerMap.put(oid, oidNormalizer);
        for (String name : attributeType.getNames()) {
            this.oidNormalizerMap.put(Strings.toLowerCaseAscii(name), oidNormalizer);
        }
    }

    @Override
    public void removeMappingFor(AttributeType attributeType) throws LdapException {
        if (attributeType == null) {
            return;
        }
        this.oidNormalizerMap.remove(attributeType.getOid());
        for (String name : attributeType.getNames()) {
            this.oidNormalizerMap.remove(Strings.toLowerCaseAscii(name));
        }
    }

    @Override
    public AttributeType lookup(String oid) throws LdapException {
        try {
            return (AttributeType)super.lookup(oid);
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public DefaultAttributeTypeRegistry copy() {
        DefaultAttributeTypeRegistry copy = new DefaultAttributeTypeRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public void clear() {
        super.clear();
        this.oidNormalizerMap.clear();
        for (Map.Entry<String, Set<AttributeType>> entry : this.oidToDescendantSet.entrySet()) {
            Set<AttributeType> descendants = entry.getValue();
            if (descendants == null) continue;
            descendants.clear();
        }
        this.oidToDescendantSet.clear();
    }
}

