/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.Snapshot;
import com.terracottatech.frs.SnapshotRequest;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.BufferBuilder;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.IOStatistics;
import com.terracottatech.frs.io.MaskingBufferSource;
import com.terracottatech.frs.io.SLABBufferSource;
import com.terracottatech.frs.io.SplittingBufferSource;
import com.terracottatech.frs.io.nio.LiveNIOStatistics;
import com.terracottatech.frs.io.nio.NIOAccessMethod;
import com.terracottatech.frs.io.nio.NIORandomAccess;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.util.NullFuture;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOManager
implements IOManager {
    private final File directory;
    private File lockFile;
    private File backupLockFile;
    private FileLock lock;
    private final long segmentSize;
    private final boolean randomAccess;
    private final long memorySize;
    private final long randomAccessSize;
    private boolean disableSync;
    private boolean useSlabs = false;
    private static final String LOCKFILE_ACTIVE = "lock file exists";
    private NIOStreamImpl backend;
    private NIORandomAccess reader;
    private BufferSource mainBuffers;
    private long written = 0L;
    private long read = 0L;
    private long writeTime = 0L;
    private long parts = 0L;
    private long requests = 0L;
    private int snapshots = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);

    public NIOManager(String home, String method, String memoryType, long segmentSize, long memorySize, long randomAccessSize, boolean randomAccess, BufferSource src) throws IOException {
        this.directory = new File(home);
        this.segmentSize = segmentSize;
        this.memorySize = memorySize;
        this.randomAccessSize = randomAccessSize;
        this.randomAccess = randomAccess;
        this.mainBuffers = src;
        this.useSlabs = memoryType != null && memoryType.equals("SLAB");
        this.open(NIOAccessMethod.valueOf(method));
    }

    public NIOManager(Configuration config, BufferSource writer) throws IOException {
        this(config.getDBHome().getAbsolutePath(), config.getString(FrsProperty.IO_NIO_ACCESS_METHOD), config.getString(FrsProperty.IO_NIO_BUFFER_SOURCE), config.getLong(FrsProperty.IO_NIO_SEGMENT_SIZE), config.getLong(FrsProperty.IO_NIO_RECOVERY_MEMORY_SIZE), config.getLong(FrsProperty.IO_NIO_RANDOM_ACCESS_MEMORY_SIZE), config.getBoolean(FrsProperty.IO_RANDOM_ACCESS), writer);
        String bufferBuilder = config.getString(FrsProperty.IO_NIO_BUFFER_BUILDER);
        if (bufferBuilder != null) {
            try {
                this.backend.setBufferBuilder((BufferBuilder)Class.forName(bufferBuilder).newInstance());
            }
            catch (ClassNotFoundException cnf) {
                LOGGER.warn("custom builder", (Throwable)cnf);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn("custom builder", (Throwable)iae);
            }
            catch (InstantiationException ie) {
                LOGGER.warn("custom builder", (Throwable)ie);
            }
            catch (ClassCastException cce) {
                LOGGER.warn("custom builder", (Throwable)cce);
            }
        }
        if (this.randomAccess) {
            this.reader.setMaxFiles(config.getInt(FrsProperty.IO_NIO_FILECACHE_MAX));
        }
        if (config.getBoolean(FrsProperty.IO_DISABLE_SYNC).booleanValue()) {
            this.backend.disableSync(true);
        }
    }

    void setBufferBuilder(BufferBuilder builder) {
        if (this.backend != null) {
            this.backend.setBufferBuilder(builder);
        }
    }

    @Override
    public long write(Chunk region, long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        long blit = System.nanoTime();
        long w = this.backend.append(region, marker);
        if (region instanceof SnapshotRequest) {
            ((SnapshotRequest)((Object)region)).setSnapshot(new NIOSnapshot());
        }
        blit = System.nanoTime() - blit;
        this.written += w;
        this.writeTime += blit;
        this.parts += (long)region.getBuffers().length;
        ++this.requests;
        return w;
    }

    @Override
    public void setMinimumMarker(long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        this.backend.setMinimumMarker(marker);
    }

    @Override
    public long getCurrentMarker() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        return this.backend.getMarker();
    }

    @Override
    public long getMinimumMarker() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        return this.backend.getMinimumMarker();
    }

    @Override
    public void sync() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        long pos = this.backend.sync();
    }

    @Override
    public long seek(long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        this.backend.seek(marker);
        return marker;
    }

    private BufferSource getRandomAccessBufferSource() {
        if (this.randomAccessSize < 0L) {
            return this.mainBuffers;
        }
        return new MaskingBufferSource(this.useSlabs ? new SLABBufferSource((int)this.randomAccessSize) : new SplittingBufferSource(64, (int)this.randomAccessSize));
    }

    private BufferSource getRecoveryBufferSource(NIOAccessMethod method) {
        return this.memorySize < 0L || method != NIOAccessMethod.STREAM ? this.mainBuffers : new MaskingBufferSource(this.useSlabs ? new SLABBufferSource((int)this.memorySize) : new SplittingBufferSource(64, (int)this.memorySize));
    }

    @Override
    public Chunk scan(long marker) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        try {
            Chunk c;
            boolean waited = this.backend.waitForWriteOf(marker);
            if (this.reader == null) {
                this.reader = this.backend.createRandomAccess(this.getRandomAccessBufferSource());
            }
            if ((c = this.reader.scan(marker)) == null) {
                throw new AssertionError((Object)("Marker " + marker + ":" + this.backend.getMarker() + " not found in " + this.directory + " during scan; waited:" + waited));
            }
            return c;
        }
        catch (InterruptedIOException ioe) {
            Thread.currentThread().interrupt();
            if (this.isClosed()) {
                throw new IllegalStateException("closed during get operation");
            }
            throw new InterruptedIOException("random access interrupted");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (this.isClosed()) {
                throw new IllegalStateException("closed during get operation");
            }
            throw new InterruptedIOException("random access interrupted");
        }
    }

    @Override
    public Chunk read(Direction dir) throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        Chunk c = this.backend.read(dir);
        if (c != null) {
            this.read += c.remaining();
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        if (this.backend != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("==PERFORMANCE(iostats)== " + this.getStatistics());
            }
            this.backend.close();
            LOGGER.debug(new Formatter(new StringBuilder()).format("==PERFORMANCE(iowrite)==  written: %.2f MB in %d parts over %d requests.\n==PERFORMANCE(iowrite)==  total time: %.3f msec -- rate: %.3f MB/s - %.4f B/part - %.2f parts/request", (double)this.written / 1048576.0, this.parts, this.requests, (double)this.writeTime * 0.001, (double)this.written * 1.0E9 / ((double)this.writeTime * 1024.0 * 1024.0), (double)this.written * 1.0 / (double)this.parts, (double)this.parts * 1.0 / (double)this.requests).out().toString());
        }
        if (this.lock != null) {
            this.lock.release();
            this.lock.channel().close();
            this.lock = null;
        }
        if (this.lockFile != null) {
            if (!this.lockFile.delete()) {
                throw new IOException("lock file cannot be deleted");
            }
            this.lockFile = null;
        }
        this.backend = null;
        this.mainBuffers.reclaim();
    }

    File getHomeDirectory() {
        return this.directory;
    }

    private void open(NIOAccessMethod method) throws IOException {
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            throw new IOException("DB home " + this.directory.getAbsolutePath() + " does not exist.");
        }
        LOGGER.info("opening with " + (Object)((Object)method) + " access method");
        this.backend = new NIOStreamImpl(this.directory, method, this.segmentSize, this.mainBuffers, this.getRecoveryBufferSource(method));
        this.lockFile = new File(this.directory, "FRS.lck");
        boolean crashed = !this.lockFile.createNewFile();
        FileOutputStream w = new FileOutputStream(this.lockFile);
        FileChannel lastSync = w.getChannel();
        this.lock = lastSync.tryLock();
        if (this.lock == null) {
            throw new IOException(LOCKFILE_ACTIVE);
        }
        this.backupLockFile = new File(this.directory, "frs.backup.lck");
        this.backupLockFile.createNewFile();
        this.backend.open();
        if (this.randomAccess) {
            this.reader = this.backend.createRandomAccess(this.getRandomAccessBufferSource());
        }
    }

    public String toString() {
        return "NIO - " + this.directory.getAbsolutePath();
    }

    public boolean isClosed() {
        return this.lock == null || !this.lock.isValid();
    }

    @Override
    public synchronized IOStatistics getStatistics() throws IOException {
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        return new LiveNIOStatistics(this.directory, this.backend, this.written, this.read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Future<Void> clean(long timeout) throws IOException {
        if (this.snapshots > 0) {
            LOGGER.debug("Live snapshots are still around. Delaying cleaning until all snapshots are released.");
            return NullFuture.INSTANCE;
        }
        if (this.backend == null) {
            throw new IOException("stream is closed");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PRE-clean " + this.getStatistics());
        }
        FileOutputStream fos = new FileOutputStream(this.backupLockFile);
        FileChannel channel = fos.getChannel();
        FileLock backupLock = null;
        try {
            backupLock = channel.tryLock(0L, Long.MAX_VALUE, false);
        }
        catch (OverlappingFileLockException e) {
            LOGGER.info("Backup file already locked.");
        }
        try {
            if (backupLock == null || !backupLock.isValid()) {
                LOGGER.info("Unable to lock backup lockfile. Delaying log file cleanup until the backup is complete.");
                NullFuture nullFuture = NullFuture.INSTANCE;
                return nullFuture;
            }
            String string = this.backupLockFile.getCanonicalPath().intern();
            synchronized (string) {
                this.backend.trimLogTail(timeout);
            }
        }
        finally {
            if (backupLock != null) {
                backupLock.release();
            }
            fos.close();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("POST-clean " + this.getStatistics());
        }
        return NullFuture.INSTANCE;
    }

    private class NIOSnapshot
    implements Snapshot {
        private boolean live = true;
        private final List<File> files;

        NIOSnapshot() {
            NIOManager.this.snapshots++;
            this.files = Collections.unmodifiableList(NIOManager.this.backend.fileList());
        }

        @Override
        public Iterator<File> iterator() {
            return this.files.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.live) {
                this.live = false;
                NIOManager nIOManager = NIOManager.this;
                synchronized (nIOManager) {
                    NIOManager.this.snapshots--;
                }
            }
        }
    }
}

