/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMapOwner;

public interface SlotMap
extends Iterable<Slot> {
    public int size();

    public boolean isEmpty();

    public Slot modify(SlotMapOwner var1, Object var2, int var3, int var4);

    public Slot query(Object var1, int var2);

    default public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotComputer<S> compute) {
        try (CompoundOperationMap mutableMap = owner.startCompoundOp(true);){
            S s = mutableMap.compute(owner, mutableMap, key, index, compute);
            return s;
        }
    }

    public <S extends Slot> S compute(SlotMapOwner var1, CompoundOperationMap var2, Object var3, int var4, SlotComputer<S> var5);

    public void add(SlotMapOwner var1, Slot var2);

    default public int dirtySize() {
        return this.size();
    }

    default public CompoundOperationMap startCompoundOp(SlotMapOwner owner, boolean forWriting) {
        return new CompoundOperationMap(owner);
    }

    @FunctionalInterface
    public static interface SlotComputer<S extends Slot> {
        public S compute(Object var1, int var2, Slot var3, CompoundOperationMap var4, SlotMapOwner var5);
    }
}

