/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Properties;
import org.jboss.threads.Messages;

public final class Version {
    private static final String JAR_NAME;
    private static final String VERSION_STRING;

    private Version() {
    }

    private static Boolean shouldLogVersion() {
        try {
            return Boolean.valueOf(System.getProperty("jboss.log-version", "true"));
        }
        catch (Throwable ignored) {
            return Boolean.FALSE;
        }
    }

    public static String getJarName() {
        return JAR_NAME;
    }

    public static String getVersionString() {
        return VERSION_STRING;
    }

    public static void main(String[] args) {
        System.out.printf("JBoss Threads version %s\n", VERSION_STRING);
    }

    static {
        String versionString;
        String jarName;
        block16: {
            Properties versionProps = new Properties();
            jarName = "(unknown)";
            versionString = "(unknown)";
            try (InputStream stream2 = Version.class.getResourceAsStream("Version.properties");){
                if (stream2 == null) break block16;
                try (InputStreamReader reader = new InputStreamReader(stream2, StandardCharsets.UTF_8);){
                    versionProps.load(reader);
                    jarName = versionProps.getProperty("jarName", jarName);
                    versionString = versionProps.getProperty("version", versionString);
                }
            }
            catch (IOException stream2) {
                // empty catch block
            }
        }
        JAR_NAME = jarName;
        VERSION_STRING = versionString;
        boolean logVersion = AccessController.doPrivileged(Version::shouldLogVersion);
        if (logVersion) {
            try {
                Messages.msg.version(versionString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

