/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.NodeLocator;
import org.apache.activemq.artemis.utils.ConcurrentUtil;

public class NamedNodeLocatorForReplication
extends NodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String backupGroupName;
    private final long retryReplicationWait;
    private Queue<Pair<TransportConfiguration, TransportConfiguration>> configurations = new LinkedList<Pair<TransportConfiguration, TransportConfiguration>>();
    private List<Pair<TransportConfiguration, TransportConfiguration>> triedConfigurations = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;

    public NamedNodeLocatorForReplication(String backupGroupName, NodeLocator.BackupRegistrationListener backupRegistrationListener, long retryReplicationWait) {
        super(backupRegistrationListener);
        this.backupGroupName = backupGroupName;
        this.retryReplicationWait = retryReplicationWait;
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block8: {
            try {
                this.lock.lock();
                if (!this.configurations.isEmpty()) break block8;
                try {
                    if (timeout != -1L) {
                        ConcurrentUtil.await((Condition)this.condition, (long)timeout);
                    } else {
                        while (this.configurations.isEmpty()) {
                            this.condition.await(this.retryReplicationWait, TimeUnit.MILLISECONDS);
                            this.configurations.addAll(this.triedConfigurations);
                            this.triedConfigurations.clear();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            if (this.backupGroupName.equals(topologyMember.getBackupGroupName()) && topologyMember.getPrimary() != null) {
                Pair configuration = new Pair((Object)topologyMember.getPrimary(), (Object)topologyMember.getBackup());
                if (!this.configurations.contains(configuration)) {
                    this.configurations.add((Pair<TransportConfiguration, TransportConfiguration>)configuration);
                }
                this.nodeID = topologyMember.getNodeId();
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getPrimaryConfiguration() {
        return this.configurations.peek();
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.triedConfigurations.add(this.configurations.poll());
            super.notifyRegistrationFailed(alreadyReplicating);
        }
        finally {
            this.lock.unlock();
        }
    }
}

