/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.dialect.fragment.language;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.dialect.fragment.ExpressionType;
import org.apache.cxf.ws.transfer.dialect.fragment.faults.InvalidExpression;
import org.apache.cxf.ws.transfer.dialect.fragment.language.FragmentDialectLanguage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentDialectLanguageXPath10
implements FragmentDialectLanguage {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();

    @Override
    public Object getResourceFragment(final Representation representation, ExpressionType expression) {
        String expressionStr = this.getXPathFromExpression(expression);
        XPath xPath = xpathFactory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix != null && !prefix.isEmpty()) {
                    Element resource = (Element)representation.getAny();
                    return resource.getAttribute("xmlns:" + prefix);
                }
                return null;
            }

            @Override
            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }
        });
        try {
            NodeList result;
            Object resource = representation.getAny();
            if (resource == null) {
                resource = DOMUtils.createDocument();
            }
            if (this.checkResultConstraints(result = (NodeList)xPath.evaluate(expressionStr, resource, XPathConstants.NODESET))) {
                if (result.getLength() == 0) {
                    return null;
                }
                return result;
            }
            return result.item(0);
        }
        catch (XPathException resource) {
            try {
                return xPath.evaluate(expressionStr, representation.getAny(), XPathConstants.STRING);
            }
            catch (XPathException ex) {
                throw new InvalidExpression();
            }
        }
    }

    private String getXPathFromExpression(ExpressionType expression) {
        if (expression.getContent().size() == 1) {
            return (String)expression.getContent().get(0);
        }
        throw new InvalidExpression();
    }

    private boolean checkResultConstraints(NodeList result) {
        if (result.getLength() > 0) {
            Node firstNode = result.item(0);
            if (firstNode.getNodeType() == 1) {
                Element firstEl = (Element)firstNode;
                String localName = firstEl.getLocalName();
                String namespace = firstEl.getNamespaceURI();
                Node parent = firstEl.getParentNode();
                for (int i = 1; i < result.getLength(); ++i) {
                    Node node = result.item(i);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        if (!this.stringEquals(element.getLocalName(), localName)) {
                            return false;
                        }
                        if (!this.stringEquals(element.getNamespaceURI(), namespace)) {
                            return false;
                        }
                        if (element.getParentNode() == parent) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean stringEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    static {
        try {
            xpathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
    }
}

