/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.spi;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.spi.ClassLoaderService;
import org.apache.cxf.common.spi.GeneratedNamespaceClassLoader;
import org.apache.cxf.common.spi.NamespaceClassCreator;
import org.apache.cxf.common.spi.NamespaceClassGenerator;

public class ClassLoaderProxyService
implements ClassLoaderService {
    private static final Logger LOG = LogUtils.getL7dLogger(ClassLoaderProxyService.class);
    private final NamespaceClassCreator srv;

    public ClassLoaderProxyService(Bus bus) {
        this(new NamespaceClassGenerator(bus));
    }

    public ClassLoaderProxyService(NamespaceClassCreator srv) {
        this.srv = srv;
    }

    @Override
    public Object createNamespaceWrapperInstance(Class<?> mcls, Map<String, String> map) {
        Class<?> cls = this.srv.createNamespaceWrapperClass(mcls, map);
        try {
            return cls.getConstructor(Map.class).newInstance(map);
        }
        catch (Throwable e) {
            LOG.warning("NamespaceWrapper not found : " + e.toString());
            return null;
        }
    }

    public class GenerateJustInTime
    extends ClassLoaderProxyService {
        public GenerateJustInTime(Bus bus) {
            super(new NamespaceClassGenerator(bus));
        }
    }

    public class LoadFirst
    extends ClassLoaderProxyService {
        public LoadFirst(Bus bus) {
            super(new GeneratedNamespaceClassLoader(bus));
        }
    }
}

