/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;

public class MPAsyncInvocationInterceptorImpl
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(MPAsyncInvocationInterceptorImpl.class);
    private final List<AsyncInvocationInterceptor> interceptors = new ArrayList<AsyncInvocationInterceptor>();

    MPAsyncInvocationInterceptorImpl(Message message) {
        super("post-marshal");
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.getInstance(message);
        List<ProviderInfo<Object>> aiiProviderList = factory.getAsyncInvocationInterceptorFactories();
        for (ProviderInfo<Object> providerInfo : aiiProviderList) {
            AsyncInvocationInterceptor aiInterceptor = ((AsyncInvocationInterceptorFactory)providerInfo.getProvider()).newInterceptor();
            this.interceptors.add(0, aiInterceptor);
        }
    }

    List<AsyncInvocationInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void handleMessage(Message message) throws Fault {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            try {
                this.interceptors.get(i).prepareContext();
                continue;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "ASYNC_INTERCEPTOR_EXCEPTION_PREPARE_CONTEXT", new Object[]{this.interceptors.get(i).getClass().getName(), t});
            }
        }
        message.getExchange().put(MPAsyncInvocationInterceptorImpl.class, (Object)this);
    }
}

